/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Expressions;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.config.ConfigSupportLevel;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.DisabledMappersInterceptor;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.NestedPropertyMappingInterceptor;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.BootstrapAdminPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.CachingPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.ClassLoaderPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigKeystorePropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.DatabasePropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.EventPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.ExportPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.FeaturePropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.HealthPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.HostnameV2PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.HttpPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.ImportPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.LoggingPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.ManagementPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.MetricsPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.ProxyPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.SecurityPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.TracingPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.TransactionPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.TruststorePropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.VaultPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

public final class PropertyMappers {
    public static final String KC_SPI_PREFIX = "kc.spi";
    public static String VALUE_MASK = "*******";
    private static MappersConfig MAPPERS;
    private static final Logger log;

    private PropertyMappers() {
    }

    public static void reset() {
        MAPPERS = new MappersConfig();
        MAPPERS.addAll(CachingPropertyMappers.getClusteringPropertyMappers());
        MAPPERS.addAll(DatabasePropertyMappers.getDatabasePropertyMappers());
        MAPPERS.addAll(HostnameV2PropertyMappers.getHostnamePropertyMappers());
        MAPPERS.addAll(HttpPropertyMappers.getHttpPropertyMappers());
        MAPPERS.addAll(HealthPropertyMappers.getHealthPropertyMappers());
        MAPPERS.addAll(ConfigKeystorePropertyMappers.getConfigKeystorePropertyMappers());
        MAPPERS.addAll(ManagementPropertyMappers.getManagementPropertyMappers());
        MAPPERS.addAll(MetricsPropertyMappers.getMetricsPropertyMappers());
        MAPPERS.addAll(EventPropertyMappers.getMetricsPropertyMappers());
        MAPPERS.addAll(ProxyPropertyMappers.getProxyPropertyMappers());
        MAPPERS.addAll(VaultPropertyMappers.getVaultPropertyMappers());
        MAPPERS.addAll(FeaturePropertyMappers.getMappers());
        MAPPERS.addAll(LoggingPropertyMappers.getMappers());
        MAPPERS.addAll(TracingPropertyMappers.getMappers());
        MAPPERS.addAll(TransactionPropertyMappers.getTransactionPropertyMappers());
        MAPPERS.addAll(ClassLoaderPropertyMappers.getMappers());
        MAPPERS.addAll(SecurityPropertyMappers.getMappers());
        MAPPERS.addAll(ExportPropertyMappers.getMappers());
        MAPPERS.addAll(ImportPropertyMappers.getMappers());
        MAPPERS.addAll(TruststorePropertyMappers.getMappers());
        MAPPERS.addAll(BootstrapAdminPropertyMappers.getMappers());
    }

    public static ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        PropertyMapper<?> mapper = PropertyMappers.getMapper(name);
        if (Environment.isRebuild().booleanValue() && PropertyMappers.isKeycloakRuntime(name, mapper) && (!NestedPropertyMappingInterceptor.getResolvingRoot().orElse(name).startsWith("quarkus.log.") || !Expressions.isEnabled())) {
            return ConfigValue.builder().withName(name).build();
        }
        if (mapper == null) {
            return context.proceed(name);
        }
        return mapper.forKey(name).getConfigValue(name, context);
    }

    public static boolean isSpiBuildTimeProperty(String name) {
        return name.startsWith(KC_SPI_PREFIX) && (name.endsWith("-provider") || name.endsWith("-enabled") || name.endsWith("-provider-default"));
    }

    public static boolean isMaybeSpiBuildTimeProperty(String name) {
        return PropertyMappers.isSpiBuildTimeProperty(name) && !name.contains("--");
    }

    private static boolean isKeycloakRuntime(String name, PropertyMapper<?> mapper) {
        if (mapper == null) {
            return name.startsWith("kc") && !PropertyMappers.isSpiBuildTimeProperty(name);
        }
        return mapper.isRunTime();
    }

    public static Map<OptionCategory, List<PropertyMapper<?>>> getRuntimeMappers() {
        return MAPPERS.getRuntimeMappers();
    }

    public static Map<OptionCategory, List<PropertyMapper<?>>> getBuildTimeMappers() {
        return MAPPERS.getBuildTimeMappers();
    }

    public static Map<String, PropertyMapper<?>> getDisabledMappers() {
        HashMap disabledMappers = new HashMap(PropertyMappers.getDisabledBuildTimeMappers());
        disabledMappers.putAll(PropertyMappers.getDisabledRuntimeMappers());
        return disabledMappers;
    }

    public static Map<String, PropertyMapper<?>> getDisabledRuntimeMappers() {
        return MAPPERS.getDisabledRuntimeMappers();
    }

    public static Map<String, PropertyMapper<?>> getDisabledBuildTimeMappers() {
        return MAPPERS.getDisabledBuildTimeMappers();
    }

    public static void sanitizeDisabledMappers() {
        MAPPERS.sanitizeDisabledMappers();
    }

    public static String maskValue(String value, PropertyMapper<?> mapper) {
        return PropertyMappers.maskValue(value, null, mapper);
    }

    public static String maskValue(String value, String configSourceName, PropertyMapper<?> mapper) {
        if (configSourceName != null && KeycloakConfigSourceProvider.isKeyStoreConfigSource(configSourceName) || mapper != null && mapper.isMask()) {
            return VALUE_MASK;
        }
        return value;
    }

    private static PropertyMapper<?> getMapperOrDefault(String property, PropertyMapper<?> defaultMapper, OptionCategory category) {
        ArrayList<PropertyMapper> mappers = new ArrayList<PropertyMapper>((Collection)MAPPERS.getOrDefault(property, Collections.emptyList()));
        if (category != null) {
            mappers.removeIf(m -> !m.getCategory().equals((Object)category));
        }
        return switch (mappers.size()) {
            case 0 -> defaultMapper;
            case 1 -> (PropertyMapper)mappers.get(0);
            default -> {
                log.debugf("Duplicated mappers for key '%s'. Used the first found.", (Object)property);
                yield (PropertyMapper)mappers.get(0);
            }
        };
    }

    public static PropertyMapper<?> getMapper(String property, OptionCategory category) {
        return PropertyMappers.getMapperOrDefault(property, null, category);
    }

    public static PropertyMapper<?> getMapper(String property) {
        return PropertyMappers.getMapper(property, null);
    }

    public static PropertyMapper<?> getMapperByCliKey(String cliKey) {
        return PropertyMappers.getKcKeyFromCliKey(cliKey).map(PropertyMappers::getMapper).orElse(null);
    }

    public static Optional<String> getKcKeyFromCliKey(String cliKey) {
        if (!cliKey.startsWith("--")) {
            return Optional.empty();
        }
        return Optional.ofNullable("kc." + cliKey.substring("--".length()));
    }

    public static Set<PropertyMapper<?>> getMappers() {
        return MAPPERS.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<WildcardPropertyMapper<?>> getWildcardMappers() {
        return MAPPERS.getWildcardMappers();
    }

    public static WildcardPropertyMapper<?> getWildcardMappedFrom(Option<?> from) {
        return PropertyMappers.MAPPERS.wildcardMapFrom.get(from.getKey());
    }

    public static boolean isSupported(PropertyMapper<?> mapper) {
        ConfigSupportLevel supportLevel = mapper.getCategory().getSupportLevel();
        return supportLevel.equals((Object)ConfigSupportLevel.SUPPORTED) || supportLevel.equals((Object)ConfigSupportLevel.DEPRECATED);
    }

    public static Optional<PropertyMapper<?>> getDisabledMapper(String property) {
        if (property == null) {
            return Optional.empty();
        }
        PropertyMapper<?> mapper = PropertyMappers.getDisabledBuildTimeMappers().get(property);
        if (mapper == null) {
            mapper = PropertyMappers.getDisabledRuntimeMappers().get(property);
        }
        return Optional.ofNullable(mapper);
    }

    public static boolean isDisabledMapper(String property) {
        return PropertyMappers.getDisabledMapper(property).isPresent() && PropertyMappers.getMapper(property) == null;
    }

    private static Set<PropertyMapper<?>> filterDeniedCategories(List<PropertyMapper<?>> mappers) {
        EnumSet allowedCategories = Environment.getParsedCommand().map(AbstractCommand::getOptionCategories).map(EnumSet::copyOf).orElseGet(() -> EnumSet.allOf(OptionCategory.class));
        return mappers.stream().filter(f -> allowedCategories.contains(f.getCategory())).collect(Collectors.toSet());
    }

    static {
        log = Logger.getLogger(PropertyMappers.class);
        PropertyMappers.reset();
    }

    private static class MappersConfig
    extends MultivaluedHashMap<String, PropertyMapper<?>> {
        private final Map<OptionCategory, List<PropertyMapper<?>>> buildTimeMappers = new EnumMap(OptionCategory.class);
        private final Map<OptionCategory, List<PropertyMapper<?>>> runtimeTimeMappers = new EnumMap(OptionCategory.class);
        private final Map<String, PropertyMapper<?>> disabledBuildTimeMappers = new HashMap();
        private final Map<String, PropertyMapper<?>> disabledRuntimeMappers = new HashMap();
        private final Set<WildcardPropertyMapper<?>> wildcardMappers = new HashSet();
        private final Map<String, WildcardPropertyMapper<?>> wildcardMapFrom = new HashMap();

        private MappersConfig() {
        }

        public void addAll(PropertyMapper<?>[] mappers) {
            for (PropertyMapper<?> mapper : mappers) {
                this.addMapper(mapper);
                if (mapper.isBuildTime()) {
                    MappersConfig.addMapperByStage(mapper, this.buildTimeMappers);
                    continue;
                }
                MappersConfig.addMapperByStage(mapper, this.runtimeTimeMappers);
            }
        }

        private static void addMapperByStage(PropertyMapper<?> mapper, Map<OptionCategory, List<PropertyMapper<?>>> mappers) {
            mappers.computeIfAbsent(mapper.getCategory(), c -> new ArrayList()).add(mapper);
        }

        public void addMapper(PropertyMapper<?> mapper) {
            if (mapper.hasWildcard()) {
                if (mapper.getMapFrom() != null) {
                    this.wildcardMapFrom.put(mapper.getMapFrom(), (WildcardPropertyMapper)mapper);
                }
                this.wildcardMappers.add((WildcardPropertyMapper)mapper);
            } else {
                MappersConfig.handleMapper(mapper, (arg_0, arg_1) -> ((MappersConfig)this).add(arg_0, arg_1));
            }
        }

        public void removeMapper(PropertyMapper<?> mapper) {
            if (mapper.hasWildcard()) {
                this.wildcardMappers.remove(mapper);
                if (mapper.getFrom() != null) {
                    this.wildcardMapFrom.remove(mapper.getMapFrom());
                }
            } else {
                MappersConfig.handleMapper(mapper, this::remove);
            }
        }

        private void remove(String key, PropertyMapper<?> mapper) {
            Object list = this.get(key);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.remove(mapper);
            }
        }

        public List<PropertyMapper<?>> get(Object key) {
            String strKey = (String)key;
            List<PropertyMapper<?>> ret = super.get(key);
            if (ret != null) {
                return ret;
            }
            if ((strKey.startsWith("kc.") || strKey.startsWith("quarkus.")) && !(ret = this.wildcardMappers.stream().filter(m -> m.matchesWildcardOptionName(strKey)).toList()).isEmpty()) {
                return ret;
            }
            return null;
        }

        public List<PropertyMapper<?>> remove(Object mapper) {
            return super.remove(mapper);
        }

        public Set<WildcardPropertyMapper<?>> getWildcardMappers() {
            return Collections.unmodifiableSet(this.wildcardMappers);
        }

        public void sanitizeDisabledMappers() {
            if (Environment.getParsedCommand().isEmpty()) {
                return;
            }
            DisabledMappersInterceptor.runWithDisabled(() -> {
                if (Environment.isRebuildCheck()) {
                    PersistedConfigSource.getInstance().runWithDisabled(Environment::getCurrentOrCreateFeatureProfile);
                } else {
                    Environment.getCurrentOrCreateFeatureProfile();
                }
                MappersConfig.sanitizeMappers(this.buildTimeMappers, this.disabledBuildTimeMappers);
                MappersConfig.sanitizeMappers(this.runtimeTimeMappers, this.disabledRuntimeMappers);
                this.assertDuplicatedMappers();
            });
        }

        private void assertDuplicatedMappers() {
            List<Map.Entry> duplicatedMappers = this.entrySet().stream().filter(e -> CollectionUtil.isNotEmpty((Collection)((Collection)e.getValue()))).filter(e -> ((List)e.getValue()).size() > 1).toList();
            boolean isBuildPhase = Environment.isRebuild() != false || Environment.isRebuildCheck() || Environment.isParsedCommand("build");
            boolean allowedForCommand = Environment.isParsedCommand("show-config");
            if (!duplicatedMappers.isEmpty()) {
                duplicatedMappers.forEach(f -> {
                    Set<PropertyMapper<?>> filteredMappers = PropertyMappers.filterDeniedCategories((List)f.getValue());
                    if (filteredMappers.size() > 1) {
                        boolean shouldBeThrown;
                        boolean areBuildTimeMappers = filteredMappers.stream().anyMatch(PropertyMapper::isBuildTime);
                        boolean bl = shouldBeThrown = !allowedForCommand && (!isBuildPhase || areBuildTimeMappers);
                        if (shouldBeThrown) {
                            throw new PropertyException(String.format("Duplicated mapper for key '%s'.", f.getKey()));
                        }
                    }
                });
            }
        }

        public Map<OptionCategory, List<PropertyMapper<?>>> getRuntimeMappers() {
            return this.runtimeTimeMappers;
        }

        public Map<OptionCategory, List<PropertyMapper<?>>> getBuildTimeMappers() {
            return this.buildTimeMappers;
        }

        public Map<String, PropertyMapper<?>> getDisabledBuildTimeMappers() {
            return this.disabledBuildTimeMappers;
        }

        public Map<String, PropertyMapper<?>> getDisabledRuntimeMappers() {
            return this.disabledRuntimeMappers;
        }

        private static void sanitizeMappers(Map<OptionCategory, List<PropertyMapper<?>>> mappers, Map<String, PropertyMapper<?>> disabledMappers) {
            mappers.forEach((category, propertyMappers) -> propertyMappers.removeIf(pm -> {
                boolean shouldRemove;
                boolean bl = shouldRemove = !pm.isEnabled();
                if (shouldRemove) {
                    MAPPERS.removeMapper((PropertyMapper<?>)pm);
                    MappersConfig.handleMapper(pm, disabledMappers::put);
                }
                return shouldRemove;
            }));
        }

        private static void handleMapper(PropertyMapper<?> mapper, BiConsumer<String, PropertyMapper<?>> operation) {
            operation.accept(mapper.getFrom(), mapper);
            if (!mapper.getFrom().equals(mapper.getTo())) {
                String to = mapper.getTo();
                operation.accept(to, mapper);
                if (to.startsWith(PropertyMappers.KC_SPI_PREFIX)) {
                    if (!mapper.getTo().contains("--")) {
                        throw new IllegalStateException("Mapper should use the new form of the SPI option with the `--` separator: " + to);
                    }
                    String legacyTo = mapper.getTo().replace("--", "-");
                    operation.accept(legacyTo, mapper);
                }
            }
        }
    }
}

