/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMessageParser
extends ProtocolMessageParser<HeartbeatMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HeartbeatMessageParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected HeartbeatMessage parseMessageContent() {
        LOGGER.debug("Parsing HeartbeatMessage");
        HeartbeatMessage msg = new HeartbeatMessage();
        this.parseHeartbeatMessageType(msg);
        this.parsePayloadLength(msg);
        this.parsePayload(msg);
        this.parsePadding(msg);
        return msg;
    }

    private void parseHeartbeatMessageType(HeartbeatMessage msg) {
        msg.setHeartbeatMessageType(this.parseByteField(1));
        LOGGER.debug("HeartbeatMessageType: " + msg.getHeartbeatMessageType().getValue());
    }

    private void parsePayloadLength(HeartbeatMessage msg) {
        msg.setPayloadLength(this.parseIntField(2));
        LOGGER.debug("PayloadLength: " + msg.getPayloadLength().getValue());
    }

    private void parsePayload(HeartbeatMessage msg) {
        msg.setPayload(this.parseByteArrayField((Integer)msg.getPayloadLength().getValue()));
        LOGGER.debug("Payload: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPayload().getValue())));
    }

    private void parsePadding(HeartbeatMessage msg) {
        msg.setPadding(this.parseByteArrayField(this.getBytesLeft()));
        LOGGER.debug("Padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPadding().getValue())));
    }
}

