/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakValueMap<K, V> {
    private final Map<K, WeakReference<V>> map = new HashMap<K, WeakReference<V>>();

    public void put(K key, V value) {
        this.map.put(key, new WeakReference<V>(value));
    }

    public V get(K key) {
        WeakReference<V> weakReference = this.map.get(key);
        return weakReference != null ? (V)weakReference.get() : null;
    }

    public V remove(K key) {
        WeakReference<V> weakReference = this.map.remove(key);
        return weakReference != null ? (V)weakReference.get() : null;
    }

    private void clean() {
        this.map.entrySet().removeIf(entry -> ((WeakReference)entry.getValue()).get() == null);
    }
}

