/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfigFile {
    private String remove;
    private String prepend;
    private Hashtable stopWords;
    private String[] defStopWords = new String[]{"a", "all", "am", "an", "and", "any", "are", "as", "at", "be", "but", "by", "can", "could", "did", "do", "does", "etc", "for", "from", "goes", "got", "had", "has", "have", "he", "her", "him", "his", "how", "if", "in", "is", "it", "let", "me", "more", "much", "must", "my", "nor", "not", "now", "of", "off", "on", "or", "our", "own", "see", "set", "shall", "she", "should", "so", "some", "than", "that", "the", "them", "then", "there", "these", "this", "those", "though", "to", "too", "us", "was", "way", "we", "what", "when", "where", "which", "who", "why", "will", "would", "yes", "yet", "you"};
    private Vector files;

    public ConfigFile(String string, Vector vector, boolean bl) {
        this.files = vector;
        String string2 = new String("IndexRemove ");
        String string3 = new String("IndexPrepend ");
        String string4 = new String("File ");
        String string5 = new String("StopWords ");
        String string6 = new String("StopWordsFile ");
        this.stopWords = new Hashtable();
        if (string == null) {
            if (!bl) {
                this.useDefaultStopWords();
            }
            return;
        }
        try {
            String string7;
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
            while ((string7 = lineNumberReader.readLine()) != null) {
                String string8;
                if (string7.startsWith(string2)) {
                    this.remove = string7.substring(string2.length(), string7.length());
                    continue;
                }
                if (string7.startsWith(string3)) {
                    this.prepend = string7.substring(string3.length(), string7.length());
                    continue;
                }
                if (string7.startsWith(string4)) {
                    string8 = string7.substring(string4.length(), string7.length());
                    vector.addElement(string8);
                    continue;
                }
                if (string7.startsWith(string6)) {
                    string8 = string7.substring(string6.length(), string7.length());
                    this.addStopWordsFile(string8);
                    continue;
                }
                if (string7.startsWith(string5)) {
                    if (bl) continue;
                    string8 = string7.substring(string5.length(), string7.length());
                    BreakIterator breakIterator = BreakIterator.getWordInstance();
                    breakIterator.setText(string8);
                    int n = breakIterator.first();
                    int n2 = breakIterator.next();
                    while (n2 != -1) {
                        String string9 = string8.substring(n, n2).trim().toLowerCase();
                        if (!string9.equals(",") && !string9.equals("")) {
                            this.stopWords.put(string9, string9);
                        }
                        n = n2;
                        n2 = breakIterator.next();
                    }
                    continue;
                }
                System.out.println("Unknown Config Keyword at line " + lineNumberReader.getLineNumber());
            }
            if (this.stopWords.isEmpty() && !bl) {
                this.useDefaultStopWords();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getURLString(String string) {
        String string2 = this.remove != null && string.startsWith(this.remove) ? string.substring(this.remove.length(), string.length()) : string;
        if (this.prepend != null) {
            string2 = this.prepend + string2;
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        return string2;
    }

    public Enumeration getStopWords() {
        return this.stopWords.elements();
    }

    public Vector getFiles() {
        return this.files;
    }

    private void useDefaultStopWords() {
        for (int i = 0; i < this.defStopWords.length; ++i) {
            this.stopWords.put(this.defStopWords[i], this.defStopWords[i]);
        }
    }

    private void addStopWordsFile(String string) {
        if (string == null) {
            return;
        }
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
            while ((string2 = lineNumberReader.readLine()) != null) {
                string2 = string2.trim();
                this.stopWords.put(string2, string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

