/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.internal.ProcedureParameterImpl;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;

public class NamedCallableQueryMementoImpl
extends AbstractNamedQueryMemento
implements NamedCallableQueryMemento {
    private final String callableName;
    private final ParameterStrategy parameterStrategy;
    private final List<NamedCallableQueryMemento.ParameterMemento> parameterMementos;
    private final String[] resultSetMappingNames;
    private final Class<?>[] resultSetMappingClasses;
    private final Set<String> querySpaces;

    public NamedCallableQueryMementoImpl(String name, String callableName, ParameterStrategy parameterStrategy, List<NamedCallableQueryMemento.ParameterMemento> parameterMementos, String[] resultSetMappingNames, Class<?>[] resultSetMappingClasses, Set<String> querySpaces, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        super(name, Object.class, cacheable, cacheRegion, cacheMode, flushMode, readOnly, timeout, fetchSize, comment, hints);
        this.callableName = callableName;
        this.parameterStrategy = parameterStrategy;
        this.parameterMementos = parameterMementos;
        this.resultSetMappingNames = resultSetMappingNames;
        this.resultSetMappingClasses = resultSetMappingClasses;
        this.querySpaces = querySpaces;
    }

    @Override
    public String getCallableName() {
        return this.callableName;
    }

    @Override
    public List<NamedCallableQueryMemento.ParameterMemento> getParameterMementos() {
        return this.parameterMementos;
    }

    @Override
    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public String[] getResultSetMappingNames() {
        return this.resultSetMappingNames;
    }

    @Override
    public Class<?>[] getResultSetMappingClasses() {
        return this.resultSetMappingClasses;
    }

    @Override
    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public ProcedureCallImplementor<?> makeProcedureCall(SharedSessionContractImplementor session) {
        return new ProcedureCallImpl(session, this);
    }

    @Override
    public ProcedureCall makeProcedureCall(SharedSessionContractImplementor session, String ... resultSetMappingNames) {
        return new ProcedureCallImpl(session, this, resultSetMappingNames);
    }

    @Override
    public ProcedureCall makeProcedureCall(SharedSessionContractImplementor session, Class<?> ... resultSetJavaTypes) {
        return null;
    }

    @Override
    public <T> QueryImplementor<T> toQuery(SharedSessionContractImplementor session) {
        return new ProcedureCallImpl(session, this);
    }

    public <T> ProcedureCallImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> javaType) {
        return new ProcedureCallImpl(session, (NamedCallableQueryMemento)this, javaType);
    }

    @Override
    public NamedQueryMemento makeCopy(String name) {
        return new NamedCallableQueryMementoImpl(name, this.callableName, this.parameterStrategy, this.parameterMementos, this.resultSetMappingNames, this.resultSetMappingClasses, this.querySpaces, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.getHints());
    }

    @Override
    public void validate(QueryEngine queryEngine) {
    }

    public static class ParameterMementoImpl<T>
    implements NamedCallableQueryMemento.ParameterMemento {
        private final Integer position;
        private final String name;
        private final ParameterMode mode;
        private final Class<T> type;
        private final BindableType<T> hibernateType;

        public ParameterMementoImpl(int position, String name, ParameterMode mode, Class<T> type, BindableType<T> hibernateType) {
            this.position = position;
            this.name = name;
            this.mode = mode;
            this.type = type;
            this.hibernateType = hibernateType;
        }

        public Integer getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public ParameterMode getMode() {
            return this.mode;
        }

        public Class<T> getType() {
            return this.type;
        }

        public BindableType<T> getHibernateType() {
            return this.hibernateType;
        }

        @Override
        public ProcedureParameterImplementor<T> resolve(SharedSessionContractImplementor session) {
            if (this.getName() != null) {
                return new ProcedureParameterImpl<T>(this.getName(), this.getMode(), this.type, this.getHibernateType());
            }
            return new ProcedureParameterImpl<T>(this.getPosition(), this.getMode(), this.type, this.getHibernateType());
        }

        public static <U> ParameterMementoImpl<U> fromRegistration(ProcedureParameterImplementor<U> registration) {
            return new ParameterMementoImpl(registration.getPosition(), registration.getName(), registration.getMode(), registration.getParameterType(), registration.getHibernateType());
        }
    }
}

