/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable;

import com.android.tools.smali.dexlib2.base.BaseExceptionHandler;
import com.android.tools.smali.dexlib2.iface.ExceptionHandler;
import com.android.tools.smali.util.ImmutableConverter;
import com.google.common.collect.ImmutableList;

public class ImmutableExceptionHandler
extends BaseExceptionHandler {
    protected final String exceptionType;
    protected final int handlerCodeAddress;
    private static final ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler> CONVERTER = new ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler>(){

        @Override
        protected boolean isImmutable(ExceptionHandler item) {
            return item instanceof ImmutableExceptionHandler;
        }

        @Override
        protected ImmutableExceptionHandler makeImmutable(ExceptionHandler item) {
            return ImmutableExceptionHandler.of(item);
        }
    };

    public ImmutableExceptionHandler(String exceptionType, int handlerCodeAddress) {
        this.exceptionType = exceptionType;
        this.handlerCodeAddress = handlerCodeAddress;
    }

    public static ImmutableExceptionHandler of(ExceptionHandler exceptionHandler) {
        if (exceptionHandler instanceof ImmutableExceptionHandler) {
            return (ImmutableExceptionHandler)exceptionHandler;
        }
        return new ImmutableExceptionHandler(exceptionHandler.getExceptionType(), exceptionHandler.getHandlerCodeAddress());
    }

    @Override
    public String getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public int getHandlerCodeAddress() {
        return this.handlerCodeAddress;
    }

    public static ImmutableList<ImmutableExceptionHandler> immutableListOf(Iterable<? extends ExceptionHandler> list) {
        return CONVERTER.toList(list);
    }
}

