/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CreateRelationshipAction
extends AbstractArchitectAction
implements ActionListener,
SelectionListener,
PlayPen.CancelableListener {
    private static final Logger logger = Logger.getLogger(CreateRelationshipAction.class);
    protected boolean identifying;
    protected TablePane pkTable;
    protected TablePane fkTable;
    protected boolean active;

    public CreateRelationshipAction(ArchitectFrame frame, boolean identifying) {
        super(frame, identifying ? Messages.getString("CreateRelationshipAction.createIdentifyingRelationshipActionName") : Messages.getString("CreateRelationshipAction.createNonIdentifyingRelationshipActionName"), identifying ? Messages.getString("CreateRelationshipAction.createIdentifyingRelationshipActionDescription") : Messages.getString("CreateRelationshipAction.createNonIdentifyingRelationshipActionDescription"), identifying ? "new_id_relationship" : "new_nonid_relationship");
        if (identifying) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 0));
        } else {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 1));
        }
        this.identifying = identifying;
        logger.debug((Object)("(constructor) hashcode is: " + super.hashCode()));
        frame.addSelectionListener(this);
        frame.addCancelableListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.getPlaypen().fireCancel();
        this.pkTable = null;
        this.fkTable = null;
        logger.debug((Object)"Starting to create relationship, setting active to TRUE!");
        this.active = true;
        this.getPlaypen().getCursorManager().placeModeStarted();
        this.getPlaypen().selectNone();
    }

    public static void doCreateRelationship(SQLTable pkTable, SQLTable fkTable, PlayPen pp, boolean identifying) {
        ArchitectSwingProject project = pp.getSession().getWorkspace();
        try {
            project.begin("Adding relationship");
            pp.startCompoundEdit("Add Relationship");
            SQLRelationship model = SQLRelationship.createRelationship((SQLTable)pkTable, (SQLTable)fkTable, (boolean)identifying);
            Relationship r = new Relationship(model, pp.getContentPane());
            pp.addRelationship(r);
            r.revalidate();
            project.commit();
        }
        catch (SQLObjectException ex) {
            logger.error((Object)"Couldn't create relationship", (Throwable)ex);
            ASUtils.showExceptionDialogNoReport(pp, Messages.getString("CreateRelationshipAction.couldNotCreateRelationship"), ex);
            project.rollback("Couldn't create relationship");
        }
        catch (Throwable e) {
            project.rollback("Couldn't create relationship");
            throw new RuntimeException(e);
        }
        finally {
            pp.endCompoundEdit("Ending the creation of a relationship");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemSelected(SelectionEvent e) {
        if (!this.active) {
            return;
        }
        if (e.getMultiselectType() == 32) {
            return;
        }
        Selectable s = e.getSelectableSource();
        if (!s.isSelected()) {
            return;
        }
        if (s instanceof TablePane) {
            if (this.pkTable == null) {
                this.pkTable = (TablePane)s;
                logger.debug((Object)("Creating relationship: PK Table is " + this.pkTable));
            } else {
                this.fkTable = (TablePane)s;
                logger.debug((Object)("Creating relationship: FK Table is " + this.fkTable));
                try {
                    CreateRelationshipAction.doCreateRelationship((SQLTable)this.pkTable.getModel(), (SQLTable)this.fkTable.getModel(), this.getPlaypen(), this.identifying);
                }
                finally {
                    this.resetAction();
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("The user clicked on a non-table component: " + s));
        }
    }

    private void resetAction() {
        this.pkTable = null;
        this.fkTable = null;
        this.getPlaypen().getCursorManager().placeModeFinished();
        this.active = false;
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void cancel() {
        this.resetAction();
    }
}

