/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;

public class ICal4JWrapper {
    private final Calendar calendar = new Calendar();
    private final TimeZoneRegistry registry;
    private final TimeZone timezone;

    public ICal4JWrapper(String tzid) {
        this.calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        this.calendar.getProperties().add((Property)Version.VERSION_2_0);
        this.calendar.getProperties().add((Property)CalScale.GREGORIAN);
        this.registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        this.timezone = this.registry.getTimeZone(tzid);
    }

    public void createAllDayEvent(String uid, java.util.Date date, String desc, String notes, String location) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = new Date(cal.getTime());
        VEvent vevent = new VEvent(d, desc);
        vevent.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE);
        vevent.getProperties().add((Property)new Uid(uid));
        if (notes != null) {
            vevent.getProperties().add((Property)new Description(notes));
        }
        if (location != null) {
            vevent.getProperties().add((Property)new Location(location));
        }
        if (this.timezone != null) {
            vevent.getProperties().add((Property)this.timezone.getVTimeZone().getTimeZoneId());
        }
        this.calendar.getComponents().add((Component)vevent);
        try {
            this.calendar.validate();
        }
        catch (ValidationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void createSpecificTimeEvent(String uid, java.util.Date date, String desc, String notes, String location, int hrs, int mns) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(14, 0);
        DateTime dt = new DateTime(cal.getTime());
        if (this.timezone != null) {
            dt.setTimeZone(this.timezone);
        }
        Dur dur = hrs == 0 && mns == 0 ? new Dur(0, 0, 0, 1) : new Dur(0, hrs, mns, 0);
        VEvent vevent = new VEvent((Date)dt, dur, desc);
        vevent.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
        vevent.getProperties().add((Property)new Uid(uid));
        if (notes != null) {
            vevent.getProperties().add((Property)new Description(notes));
        }
        if (location != null) {
            vevent.getProperties().add((Property)new Location(location));
        }
        this.calendar.getComponents().add((Component)vevent);
        try {
            this.calendar.validate();
        }
        catch (ValidationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void createToDo(String uid, String desc, String notes, String location) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        VToDo vtodo = new VToDo(new Date(cal.getTime()), new Dur(0, 0, 0, 1), desc);
        vtodo.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE);
        vtodo.getProperties().add((Property)new Uid(uid));
        if (notes != null) {
            vtodo.getProperties().add((Property)new Description(notes));
        }
        if (location != null) {
            vtodo.getProperties().add((Property)new Location(location));
        }
        if (this.timezone != null) {
            vtodo.getProperties().add((Property)this.timezone.getVTimeZone().getTimeZoneId());
        }
        this.calendar.getComponents().add((Component)vtodo);
        try {
            this.calendar.validate();
        }
        catch (ValidationException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void write(File outfile) throws Exception {
        if (this.calendar.getComponents().size() > 0) {
            FileOutputStream fout = new FileOutputStream(outfile);
            CalendarOutputter outputter = new CalendarOutputter();
            outputter.output(this.calendar, (OutputStream)fout);
            fout.close();
        }
    }
}

