// -*- C++ -*-

// Copyright (C) 2005, 2006, 2009 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the terms
// of the GNU General Public License as published by the Free Software
// Foundation; either version 3, or (at your option) any later
// version.

// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.

// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.

// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// Copyright (C) 2004 Ami Tavory and Vladimir Dreizin, IBM-HRL.

// Permission to use, copy, modify, sell, and distribute this software
// is hereby granted without fee, provided that the above copyright
// notice appears in all copies, and that both that copyright notice
// and this permission notice appear in supporting documentation. None
// of the above authors, nor IBM Haifa Research Laboratories, make any
// representation about the suitability of this software for any
// purpose. It is provided "as is" without express or implied
// warranty.

/**
 * @file split_join_fn_imps.hpp
 * Contains an implementation class for a pairing heap.
 */

PB_DS_CLASS_T_DEC
template<typename Pred>
void
PB_DS_CLASS_C_DEC::
split(Pred pred, PB_DS_CLASS_C_DEC& other)
{
  _GLIBCXX_DEBUG_ONLY(assert_valid();)
    _GLIBCXX_DEBUG_ONLY(other.assert_valid();)

    other.clear();

  if (base_type::empty())
    {
      _GLIBCXX_DEBUG_ONLY(assert_valid();)
        _GLIBCXX_DEBUG_ONLY(other.assert_valid();)

        return;
    }

  base_type::to_linked_list();

  node_pointer p_out = base_type::prune(pred);

  while (p_out != NULL)
    {
      _GLIBCXX_DEBUG_ASSERT(base_type::m_size > 0);
      --base_type::m_size;

      ++other.m_size;

      node_pointer p_next = p_out->m_p_next_sibling;

      p_out->m_p_l_child = p_out->m_p_next_sibling = p_out->m_p_prev_or_parent = NULL;

      other.push_imp(p_out);

      p_out = p_next;
    }

  _GLIBCXX_DEBUG_ONLY(other.assert_valid();)

    node_pointer p_cur = base_type::m_p_root;

  base_type::m_p_root = NULL;

  while (p_cur != NULL)
    {
      node_pointer p_next = p_cur->m_p_next_sibling;

      p_cur->m_p_l_child = p_cur->m_p_next_sibling = p_cur->m_p_prev_or_parent = NULL;

      push_imp(p_cur);

      p_cur = p_next;
    }

  _GLIBCXX_DEBUG_ONLY(assert_valid();)
    _GLIBCXX_DEBUG_ONLY(other.assert_valid();)
    }

PB_DS_CLASS_T_DEC
inline void
PB_DS_CLASS_C_DEC::
join(PB_DS_CLASS_C_DEC& other)
{
  _GLIBCXX_DEBUG_ONLY(assert_valid();)
    _GLIBCXX_DEBUG_ONLY(other.assert_valid();)

    if (other.m_p_root == NULL)
      {
        _GLIBCXX_DEBUG_ONLY(assert_valid();)
	  _GLIBCXX_DEBUG_ONLY(other.assert_valid();)

	  return;
      }

  if (base_type::m_p_root == NULL)
    base_type::m_p_root = other.m_p_root;
  else if (Cmp_Fn::operator()(base_type::m_p_root->m_value, other.m_p_root->m_value))
    {
      base_type::make_child_of(base_type::m_p_root, other.m_p_root);
      _GLIBCXX_DEBUG_ONLY(base_type::assert_node_consistent(other.m_p_root, false));

      base_type::m_p_root = other.m_p_root;
    }
  else
    {
      base_type::make_child_of(other.m_p_root, base_type::m_p_root);
      _GLIBCXX_DEBUG_ONLY(base_type::assert_node_consistent(base_type::m_p_root, false));
    }

  base_type::m_size += other.m_size;

  other.m_p_root = NULL;
  other.m_size = 0;

  _GLIBCXX_DEBUG_ONLY(assert_valid();)
    _GLIBCXX_DEBUG_ONLY(other.assert_valid();)
    }

