/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Objects;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.DisplayName;

public class TransformedComponentFileArtifactIdentifier
implements ComponentArtifactIdentifier,
DisplayName {
    private final ComponentIdentifier componentId;
    private final String fileName;
    private final String originalFileName;

    public TransformedComponentFileArtifactIdentifier(ComponentIdentifier componentId, String fileName, String originalFileName) {
        this.componentId = componentId;
        this.fileName = fileName;
        this.originalFileName = originalFileName;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getDisplayName() {
        return this.getOriginalFileName() + " -> " + this.getFileName() + " (" + this.getComponentIdentifier().getDisplayName() + ")";
    }

    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransformedComponentFileArtifactIdentifier other = (TransformedComponentFileArtifactIdentifier)obj;
        return this.componentId.equals(other.componentId) && this.fileName.equals(other.fileName) && this.originalFileName.equals(other.originalFileName);
    }

    public int hashCode() {
        return Objects.hash(this.componentId, this.fileName, this.originalFileName);
    }
}

