/*	$OpenBSD: crypto_arch.h,v 1.5 2025/02/14 12:01:58 jsing Exp $ */
/*
 * Copyright (c) 2024 Joel Sing <jsing@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdint.h>

#ifndef HEADER_CRYPTO_ARCH_H
#define HEADER_CRYPTO_ARCH_H

#define HAVE_CRYPTO_CPU_CAPS_INIT
#define HAVE_CRYPTO_CPU_CAPS_IA32

#ifndef __ASSEMBLER__
extern uint64_t crypto_cpu_caps_amd64;
#endif

#define CRYPTO_CPU_CAPS_AMD64_SHA	(1ULL << 0)

#ifndef OPENSSL_NO_ASM

#define HAVE_AES_CBC_ENCRYPT_INTERNAL
#define HAVE_AES_SET_ENCRYPT_KEY_INTERNAL
#define HAVE_AES_SET_DECRYPT_KEY_INTERNAL
#define HAVE_AES_ENCRYPT_INTERNAL
#define HAVE_AES_DECRYPT_INTERNAL

#define HAVE_RC4_INTERNAL
#define HAVE_RC4_SET_KEY_INTERNAL

#if 0
#define HAVE_SHA1_BLOCK_DATA_ORDER
#define HAVE_SHA1_BLOCK_GENERIC

#define HAVE_SHA256_BLOCK_DATA_ORDER
#define HAVE_SHA256_BLOCK_GENERIC

#define HAVE_SHA512_BLOCK_DATA_ORDER
#define HAVE_SHA512_BLOCK_GENERIC
#endif

#endif

#endif
