untrusted comment: signature from openbsd 5.5 base secret key
RWRGy8gxk9N930c7VP1Rwdwv7NcTbfPjzv73AiCTMYAQVK02BVoRg6Azc8z61ZthC1/bJ62TxyZvzJqNULZA5p2xZWA0FmiADgU=

OpenBSD 5.5 errata 17, Dec 5, 2014:

An incorrect memcpy call would result in corrupted MAC addresses when
using PPPOE.

Apply patch using:

    signify -Vep /etc/signify/openbsd-55-base.pub -x 017_pppoe.patch.sig \
        -m - | (cd /usr/src && patch -p0)

Then build and install a new kernel.

Index: sys/net/if_ethersubr.c
===================================================================
RCS file: /cvs/src/sys/net/if_ethersubr.c,v
retrieving revision 1.162
diff -u -p -r1.162 if_ethersubr.c
--- sys/net/if_ethersubr.c	17 Feb 2014 14:48:48 -0000	1.162
+++ sys/net/if_ethersubr.c	1 Dec 2014 17:51:08 -0000
@@ -647,7 +647,12 @@ decapsulate:
 			goto done;
 
 		eh_tmp = mtod(m, struct ether_header *);
-		memcpy(eh_tmp, eh, sizeof(struct ether_header));
+		/*
+		 * danger!
+		 * eh_tmp and eh may overlap because eh
+		 * is stolen from the mbuf above.
+		 */
+		memmove(eh_tmp, eh, sizeof(struct ether_header));
 #ifdef PIPEX
 		if (pipex_enable) {
 			struct pipex_session *session;
