untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfozyUBnThyGZCIuwm8E5iBHDMeDu5Nmxy6NhiLMBb4SoIJE/00p7nTUvwuQjU7Weu7nKW+bo/Gp68mSL9PYg6Qo=

OpenBSD 7.5 errata 020, March 25, 2025:

Prevent out-of-bounds write in FreeType heap.  CVE-2025-27363

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 020_freetype.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install freetype:
    cd /usr/xenocara/lib/freetype
    make obj
    make build

Index: lib/freetype/src/truetype/ttgload.c
===================================================================
RCS file: /cvs/xenocara/lib/freetype/src/truetype/ttgload.c,v
diff -u -p -r1.35 ttgload.c
--- lib/freetype/src/truetype/ttgload.c	21 May 2023 09:25:34 -0000	1.35
+++ lib/freetype/src/truetype/ttgload.c	17 Mar 2025 22:26:32 -0000
@@ -1889,7 +1889,7 @@
         short        i, limit;
         FT_SubGlyph  subglyph;
 
-        FT_Outline  outline;
+        FT_Outline  outline = { 0, 0, NULL, NULL, NULL, 0 };
         FT_Vector*  points    = NULL;
         char*       tags      = NULL;
         short*      contours  = NULL;
@@ -1897,6 +1897,13 @@
 
 
         limit = (short)gloader->current.num_subglyphs;
+
+        /* make sure this isn't negative as we're going to add 4 later */
+        if ( limit < 0 )
+        {
+          error = FT_THROW( Invalid_Argument );
+          goto Exit;
+        }
 
         /* construct an outline structure for              */
         /* communication with `TT_Vary_Apply_Glyph_Deltas' */
