/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class AlphaNumericSequenceNameCritic
extends CriticAndSettings {
    private final Pattern pattern = Pattern.compile("^[a-z_][a-z0-9_]*$", 2);

    public AlphaNumericSequenceNameCritic() {
        super(CriticAndSettings.StarterPlatformTypes.GENERIC.getName(), Messages.getString("AlphaNumericSequenceNameCritic.name"));
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        if (!(subject instanceof SQLColumn)) {
            return Collections.emptyList();
        }
        SQLColumn so = (SQLColumn)subject;
        String physName = so.getAutoIncrementSequenceName();
        if (physName == null) {
            return Collections.emptyList();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (!this.pattern.matcher(physName).matches()) {
            criticisms.add(new Criticism(so, Messages.getString("AlphaNumericSequenceNameCritic.quickFixMessage", so.getName()), this, new CriticFix[0]));
        }
        return criticisms;
    }
}

