/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.output.xsd.SchemaInfo;
import com.thaiopensource.relaxng.output.xsd.SourceUriGenerator;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.xml.util.Naming;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PrefixManager
implements SourceUriGenerator {
    private final Map prefixMap = new HashMap();
    private final Set usedPrefixes = new HashSet();
    private final Set reservedPrefixes = new HashSet();
    private int nextGenIndex = 1;
    private static final String[] xsdPrefixes = new String[]{"xs", "xsd"};
    private static final int MAX_PREFIX_LENGTH = 10;

    PrefixManager(SchemaInfo schemaInfo) {
        this.usePrefix("xml", "http://www.w3.org/XML/1998/namespace");
        new PrefixSelector(schemaInfo).assignPrefixes();
    }

    String getPrefix(String string) {
        String string2 = (String)this.prefixMap.get(string);
        if (string2 == null && string.equals("http://www.w3.org/2001/XMLSchema")) {
            int n = 0;
            while (n < xsdPrefixes.length) {
                if (this.tryUsePrefix(xsdPrefixes[n], string)) {
                    return xsdPrefixes[n];
                }
                ++n;
            }
        }
        if (string2 == null) {
            string2 = this.tryUseUri(string);
        }
        if (string2 == null) {
            while (!this.tryUsePrefix(string2 = "ns" + Integer.toString(this.nextGenIndex++), string)) {
            }
        }
        return string2;
    }

    private String tryUseUri(String string) {
        String string2 = PrefixManager.chooseSegment(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() <= 10 && this.tryUsePrefix(string2, string)) {
            return string2;
        }
        int n = 1;
        while (n <= string2.length()) {
            String string3 = string2.substring(0, n);
            if (this.tryUsePrefix(string3, string)) {
                return string3;
            }
            ++n;
        }
        return null;
    }

    private boolean tryUsePrefix(String string, String string2) {
        if (!this.prefixOk(string, string2)) {
            return false;
        }
        this.usePrefix(string, string2);
        return true;
    }

    private boolean prefixOk(String string, String string2) {
        return !this.usedPrefixes.contains(string) && (!this.reservedPrefixes.contains(string) || !string2.equals("http://www.w3.org/2001/XMLSchema"));
    }

    private void usePrefix(String string, String string2) {
        this.usedPrefixes.add(string);
        this.prefixMap.put(string2, string);
    }

    private static String chooseSegment(String string) {
        String string2;
        int n;
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            String string3 = string.substring(n2 + 1).toLowerCase();
            if (Naming.isNcname(string3)) {
                return string3;
            }
        } else {
            n2 = string.length();
        }
        while ((n = string.lastIndexOf(47, n2 - 1)) >= 0 && (n <= 0 || string.charAt(n - 1) != '/')) {
            String string4 = string.substring(n + 1, n2).toLowerCase();
            if (PrefixManager.segmentOk(string4)) {
                return string4;
            }
            n2 = n;
        }
        n2 = string.indexOf(58);
        if (n2 >= 0 && PrefixManager.segmentOk(string2 = string.substring(n2 + 1).toLowerCase())) {
            return string2;
        }
        return null;
    }

    private static boolean segmentOk(String string) {
        return Naming.isNcname(string) && !string.equals("ns") && !string.equals("namespace");
    }

    public String generateSourceUri(String string) {
        if (string.equals("")) {
            return "local";
        }
        return "/" + this.getPrefix(string);
    }

    class PrefixSelector
    extends AbstractVisitor {
        private final SchemaInfo si;
        private String inheritedNamespace;
        private final Map namespacePrefixUsageMap = new HashMap();

        PrefixSelector(SchemaInfo schemaInfo) {
            this.si = schemaInfo;
            this.inheritedNamespace = "";
            schemaInfo.getGrammar().componentsAccept(this);
            Context context = schemaInfo.getGrammar().getContext();
            if (context != null) {
                Enumeration enumeration = context.prefixes();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (string.equals("")) continue;
                    this.notePrefix(string, this.resolveNamespace(context.resolveNamespacePrefix(string)));
                }
            }
        }

        public Object visitElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            elementPattern.getChild().accept(this);
            return null;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            return attributePattern.getNameClass().accept(this);
        }

        public Object visitChoice(ChoiceNameClass choiceNameClass) {
            choiceNameClass.childrenAccept(this);
            return null;
        }

        public Object visitName(NameNameClass nameNameClass) {
            this.notePrefix(nameNameClass.getPrefix(), this.resolveNamespace(nameNameClass.getNamespaceUri()));
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (string == null || string.equals("")) continue;
                String string2 = this.resolveNamespace((String)entry.getValue());
                this.notePrefix(string, string2);
                if (string2.equals("http://www.w3.org/2001/XMLSchema")) continue;
                PrefixManager.this.reservedPrefixes.add(string);
            }
            return null;
        }

        private String resolveNamespace(String string) {
            return string == NameNameClass.INHERIT_NS ? this.inheritedNamespace : string;
        }

        private void notePrefix(String string, String string2) {
            PrefixUsage prefixUsage;
            if (string == null || string2 == null || string2.equals("")) {
                return;
            }
            HashMap<String, PrefixUsage> hashMap = (HashMap<String, PrefixUsage>)this.namespacePrefixUsageMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, PrefixUsage>();
                this.namespacePrefixUsageMap.put(string2, hashMap);
            }
            if ((prefixUsage = (PrefixUsage)hashMap.get(string)) == null) {
                prefixUsage = new PrefixUsage();
                hashMap.put(string, prefixUsage);
            }
            ++prefixUsage.count;
        }

        public Object visitComposite(CompositePattern compositePattern) {
            compositePattern.childrenAccept(this);
            return null;
        }

        public Object visitUnary(UnaryPattern unaryPattern) {
            return unaryPattern.getChild().accept(this);
        }

        public Object visitDefine(DefineComponent defineComponent) {
            defineComponent.getBody().accept(this);
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            String string = this.inheritedNamespace;
            this.inheritedNamespace = includeComponent.getNs();
            this.si.getSchema(includeComponent.getHref()).componentsAccept(this);
            this.inheritedNamespace = string;
            return null;
        }

        void assignPrefixes() {
            Iterator iterator = this.namespacePrefixUsageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (string.equals("") || string.equals("http://www.w3.org/XML/1998/namespace") || (map = (Map)entry.getValue()) == null) continue;
                Map.Entry entry2 = null;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry3 = iterator2.next();
                    if (entry2 != null && ((PrefixUsage)entry3.getValue()).count <= ((PrefixUsage)entry2.getValue()).count || !PrefixManager.this.prefixOk((String)entry3.getKey(), string)) continue;
                    entry2 = entry3;
                }
                if (entry2 == null) continue;
                PrefixManager.this.usePrefix((String)entry2.getKey(), string);
            }
        }
    }

    static class PrefixUsage {
        int count;

        PrefixUsage() {
        }
    }
}

