/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.client.authentication;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.BasicAuthHelper;

public class ClientIdAndSecretCredentialsProvider
implements ClientCredentialsProvider {
    private static Logger logger = Logger.getLogger(ClientIdAndSecretCredentialsProvider.class);
    public static final String PROVIDER_ID = "secret";
    private String clientSecret;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void init(AdapterConfig deployment, Object config) {
        this.clientSecret = config == null ? null : config.toString();
    }

    @Override
    public void setClientCredentials(AdapterConfig deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String clientId = deployment.getResource();
        if (!deployment.isPublicClient()) {
            if (this.clientSecret != null) {
                String authorization = BasicAuthHelper.RFC6749.createHeader(clientId, this.clientSecret);
                requestHeaders.put("Authorization", authorization);
            } else {
                logger.warnf("Client '%s' doesn't have secret available", (Object)clientId);
            }
        } else {
            formParams.put("client_id", clientId);
        }
    }
}

