/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import oracle.jdbc.OracleType;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonGenerator;
import org.hibernate.dialect.OracleOsonJacksonHelper;
import org.hibernate.dialect.type.OracleJsonJdbcType;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JsonHelper;
import org.hibernate.type.descriptor.jdbc.spi.JsonGeneratingVisitor;
import org.hibernate.type.format.OsonDocumentReader;
import org.hibernate.type.format.OsonDocumentWriter;

public class OracleOsonJdbcType
extends OracleJsonJdbcType {
    public static final OracleOsonJdbcType INSTANCE = new OracleOsonJdbcType(null);
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(OracleOsonJdbcType.class);
    static final OracleJsonFactory OSON_JSON_FACTORY = new OracleJsonFactory();

    private OracleOsonJdbcType(EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
    }

    @Override
    public String toString() {
        return "OracleOsonJdbcType";
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new OracleOsonJdbcType(mappingType);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return super.getBinder(javaType);
        }
        return new BasicBinder<X>(javaType, this){

            private <T> byte[] toOson(T value, JavaType<T> javaType, WrapperOptions options) throws Exception {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (OracleOsonJdbcType.this.getEmbeddableMappingType() != null) {
                    try (OracleJsonGenerator generator = OSON_JSON_FACTORY.createJsonBinaryGenerator((OutputStream)out);){
                        JsonGeneratingVisitor.INSTANCE.visit(OracleOsonJdbcType.this.getEmbeddableMappingType(), value, options, new OsonDocumentWriter(generator));
                    }
                }
                try (Closeable osonGen = OracleOsonJacksonHelper.createWriteTarget(out);){
                    options.getJsonFormatMapper().writeToTarget(value, javaType, osonGen, options);
                }
                return out.toByteArray();
            }

            private boolean useUtf8(WrapperOptions options) {
                return OracleOsonJdbcType.this.getEmbeddableMappingType() == null && !options.getJsonFormatMapper().supportsTargetType(OracleOsonJacksonHelper.WRITER_CLASS);
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        String json = OracleOsonJdbcType.this.toString(value, this.getJavaType(), options);
                        st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
                    } else {
                        st.setObject(index, (Object)this.toOson(value, this.getJavaType(), options), (SQLType)OracleType.JSON);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                try {
                    if (this.useUtf8(options)) {
                        String json = OracleOsonJdbcType.this.toString(value, this.getJavaType(), options);
                        st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
                    } else {
                        st.setObject(name, (Object)this.toOson(value, this.getJavaType(), options), (SQLType)OracleType.JSON);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        if (javaType.getJavaType() == String.class || javaType.getJavaType() == Object.class) {
            return super.getExtractor(javaType);
        }
        return new BasicExtractor<X>(javaType, this){

            private X fromOson(InputStream osonBytes, WrapperOptions options) throws Exception {
                if (OracleOsonJdbcType.this.getEmbeddableMappingType() != null) {
                    return JsonHelper.deserialize(OracleOsonJdbcType.this.getEmbeddableMappingType(), new OsonDocumentReader(OSON_JSON_FACTORY.createJsonBinaryParser(osonBytes)), javaType.getJavaTypeClass() != Object[].class, options);
                }
                try (Closeable osonParser = OracleOsonJacksonHelper.createReadSource(osonBytes);){
                    Object j = options.getJsonFormatMapper().readFromSource(this.getJavaType(), osonParser, options);
                    return j;
                }
            }

            private boolean useUtf8(WrapperOptions options) {
                return OracleOsonJdbcType.this.getEmbeddableMappingType() == null && !options.getJsonFormatMapper().supportsSourceType(OracleOsonJacksonHelper.READER_CLASS);
            }

            private X doExtraction(OracleJsonDatum datum, WrapperOptions options) throws SQLException {
                if (datum == null) {
                    return null;
                }
                InputStream osonBytes = datum.getStream();
                try {
                    return this.fromOson(osonBytes, options);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }

            private X fromString(byte[] json, WrapperOptions options) throws SQLException {
                if (json == null) {
                    return null;
                }
                return OracleOsonJdbcType.this.fromString(new String(json, StandardCharsets.UTF_8), this.getJavaType(), options);
            }

            private byte[] getBytesFromResultSetByIndex(ResultSet rs, int index) throws SQLException {
                try {
                    return rs.getBytes(index);
                }
                catch (SQLFeatureNotSupportedException nse) {
                    return rs.getString(index).getBytes();
                }
            }

            private byte[] getBytesFromStatementByIndex(CallableStatement st, int index) throws SQLException {
                try {
                    return st.getBytes(index);
                }
                catch (SQLFeatureNotSupportedException nse) {
                    return st.getString(index).getBytes();
                }
            }

            private byte[] getBytesFromStatementByName(CallableStatement st, String columnName) throws SQLException {
                try {
                    return st.getBytes(columnName);
                }
                catch (SQLFeatureNotSupportedException nse) {
                    return st.getString(columnName).getBytes();
                }
            }

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                if (this.useUtf8(options)) {
                    return this.fromString(this.getBytesFromResultSetByIndex(rs, paramIndex), options);
                }
                try {
                    OracleJsonDatum ojd = rs.getObject(paramIndex, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.BLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(this.getBytesFromResultSetByIndex(rs, paramIndex), options);
                    }
                    throw exc;
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (this.useUtf8(options)) {
                    return this.fromString(this.getBytesFromStatementByIndex(statement, index), options);
                }
                try {
                    OracleJsonDatum ojd = statement.getObject(index, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.CLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(this.getBytesFromStatementByIndex(statement, index), options);
                    }
                    throw exc;
                }
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (this.useUtf8(options)) {
                    return this.fromString(this.getBytesFromStatementByName(statement, name), options);
                }
                try {
                    OracleJsonDatum ojd = statement.getObject(name, OracleJsonDatum.class);
                    return this.doExtraction(ojd, options);
                }
                catch (SQLException exc) {
                    if (exc.getErrorCode() == 17004) {
                        LOG.invalidJSONColumnType(OracleType.CLOB.getName(), OracleType.JSON.getName());
                        return this.fromString(this.getBytesFromStatementByName(statement, name), options);
                    }
                    throw exc;
                }
            }
        };
    }
}

