/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding.generator;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;

public class EncodingGenerator {
    private static final Logger logger = Logger.getLogger(EncodingGenerator.class.getName());
    private File targetDirectory;
    private DefaultConfiguration propertySet;
    private File sourceDirectory;
    public static final Integer ZERO = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodingGenerator(File targetDirectory, File sourceDirectory) throws IOException {
        if (targetDirectory == null) {
            throw new NullPointerException();
        }
        if (!targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + targetDirectory);
        }
        if (!targetDirectory.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + targetDirectory);
        }
        if (sourceDirectory == null) {
            throw new NullPointerException();
        }
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + sourceDirectory);
        }
        if (!sourceDirectory.canRead()) {
            throw new IllegalArgumentException("Not readable: " + sourceDirectory);
        }
        this.sourceDirectory = sourceDirectory;
        this.targetDirectory = targetDirectory;
        this.propertySet = new DefaultConfiguration();
        try (InputStream propIn = ObjectUtilities.getResourceRelativeAsStream((String)"encodings.properties", EncodingGenerator.class);){
            this.propertySet.load(propIn);
        }
    }

    public void generatedFormatA(Properties specifications, BufferedReader input, OutputStream output) throws IOException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (output == null) {
            throw new NullPointerException();
        }
        if (specifications == null) {
            throw new NullPointerException();
        }
        Integer[] data = new Integer[256];
        data[0] = ZERO;
        String s = input.readLine();
        while (s != null) {
            String targetChar;
            if (s.length() > 0 && s.charAt(0) == '#') {
                s = input.readLine();
                continue;
            }
            StringTokenizer strtok = new StringTokenizer(s);
            if (!strtok.hasMoreTokens()) {
                s = input.readLine();
                continue;
            }
            String sourceChar = strtok.nextToken().trim();
            if (sourceChar.length() == 0) {
                s = input.readLine();
                continue;
            }
            Integer sourceVal = Integer.decode(sourceChar);
            if (strtok.hasMoreTokens() && !((targetChar = strtok.nextToken()).length() > 0 && targetChar.charAt(0) == '#')) {
                data[sourceVal.intValue()] = Integer.decode(targetChar);
            }
            s = input.readLine();
        }
        int[] indices = new int[256];
        int[] values = new int[256];
        int index = 0;
        int prevIdx = 0;
        for (int i = 1; i < data.length; ++i) {
            Integer integer = data[i];
            if (integer == null) continue;
            Integer prev = data[prevIdx];
            values[index] = integer - prev;
            indices[index] = i - prevIdx;
            prevIdx = i;
            ++index;
        }
        ObjectOutputStream oout = new ObjectOutputStream(output);
        oout.writeObject(new External8BitEncodingData(indices, values));
        oout.flush();
    }

    public void generateAll() throws IOException {
        for (String key : this.propertySet.keySet()) {
            if (!key.startsWith("encodings.")) {
                logger.info("Encoding prefix not found.");
                continue;
            }
            if (!key.endsWith(".Filename")) continue;
            try {
                this.generate(key.substring(0, key.length() - 8));
            }
            catch (Exception e) {
                logger.warning("Failed to generate Encoding " + key + " : " + e);
            }
        }
    }

    public void generate(String prefix) throws IOException {
        String filename = this.propertySet.getConfigProperty(prefix + "Filename");
        String className = this.propertySet.getConfigProperty(prefix + "ClassName");
        String encoding = this.propertySet.getConfigProperty(prefix + "Encoding");
        if (filename == null) {
            logger.info("Not generating Encoding: " + prefix + ": Filename missing");
            return;
        }
        if (className == null) {
            logger.info("Not generating Encoding: " + prefix + ": ClassName missing");
            return;
        }
        if (encoding == null) {
            logger.info("Not generating Encoding: " + prefix + ": Encoding missing");
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("name", className);
        properties.setProperty("source", filename);
        properties.setProperty("encoding", encoding);
        File sourceFile = new File(this.sourceDirectory, className + ".ser");
        File targetFile = new File(this.targetDirectory, filename);
        System.out.println("Generated Java File:  " + sourceFile);
        System.out.println("Source Specification: " + targetFile);
        BufferedOutputStream bw = new BufferedOutputStream(new FileOutputStream(sourceFile));
        BufferedReader input = new BufferedReader(new FileReader(targetFile));
        this.generatedFormatA(properties, input, bw);
        input.close();
        bw.close();
    }

    public void generatePropertyIndex() throws IOException {
        Properties props = new Properties();
        for (String key : this.propertySet.keySet()) {
            if (!key.startsWith("encodings.")) {
                logger.info("Encoding prefix not found.");
                continue;
            }
            if (!key.endsWith(".Filename")) continue;
            try {
                this.generateEncodingEntry(props, key.substring(0, key.length() - 8));
            }
            catch (Exception e) {
                logger.warning("Failed to generate Encoding " + key + " : " + e);
            }
        }
        File sourceFile = new File(this.sourceDirectory, "encodings.properties");
        FileOutputStream fout = new FileOutputStream(sourceFile);
        props.store(fout, "Generated on " + new Date());
        fout.close();
    }

    private void generateEncodingEntry(Properties props, String prefix) {
        String className = this.propertySet.getConfigProperty(prefix + "ClassName");
        String encoding = this.propertySet.getConfigProperty(prefix + "Encoding");
        if (className == null) {
            logger.info("Not generating Encoding: " + prefix + ": ClassName missing");
            return;
        }
        if (encoding == null) {
            logger.info("Not generating Encoding: " + prefix + ": Encoding missing");
            return;
        }
        props.setProperty(encoding, className + ".ser");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Need two parameters: EncodingsDirectory and Source-Directory");
        }
        String encodingDirName = args[0];
        String sourceDirName = args[1];
        LibFontBoot.getInstance().start();
        File encodingsDir = new File(encodingDirName).getAbsoluteFile();
        File sourceDir = new File(sourceDirName).getAbsoluteFile();
        EncodingGenerator gen = new EncodingGenerator(encodingsDir, sourceDir);
        gen.generateAll();
        gen.generatePropertyIndex();
    }
}

