/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.TimeUnit;

public class ClockUtil {
    private static volatile Realtime handler = new Realtime(){

        @Override
        public long nanoRealtime() {
            return System.nanoTime();
        }
    };

    public static void setRealtimeHandler(Realtime systemHandler) {
        if (systemHandler == null) {
            throw new NullPointerException("realtime system handler must not be null!");
        }
        handler = systemHandler;
    }

    public static long nanoRealtime() {
        return handler.nanoRealtime();
    }

    public static long delta(long pastNanoRealtime, TimeUnit unit) {
        if (pastNanoRealtime > 0L) {
            return unit.convert(handler.nanoRealtime() - pastNanoRealtime, TimeUnit.NANOSECONDS);
        }
        return 0L;
    }

    public static interface Realtime {
        public long nanoRealtime();
    }
}

