/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.io.JBBPCountableBitStream;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JBBPBitOutputStream
extends FilterOutputStream
implements JBBPCountableBitStream {
    private final boolean msb0;
    private int bitBuffer;
    private int bitBufferCount;
    private long byteCounter;

    public JBBPBitOutputStream(OutputStream out) {
        this(out, JBBPBitOrder.LSB0);
    }

    public JBBPBitOutputStream(OutputStream out, JBBPBitOrder order) {
        super(out);
        this.msb0 = order == JBBPBitOrder.MSB0;
    }

    @Override
    public JBBPBitOrder getBitOrder() {
        return this.msb0 ? JBBPBitOrder.MSB0 : JBBPBitOrder.LSB0;
    }

    public void writeShort(int value, JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            this.write(value >>> 8);
            this.write(value);
        } else {
            this.write(value);
            this.write(value >>> 8);
        }
    }

    public void writeInt(int value, JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            this.writeShort(value >>> 16, byteOrder);
            this.writeShort(value, byteOrder);
        } else {
            this.writeShort(value, byteOrder);
            this.writeShort(value >>> 16, byteOrder);
        }
    }

    public void writeFloat(float value, JBBPByteOrder byteOrder) throws IOException {
        int intValue = Float.floatToIntBits(value);
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            this.writeShort(intValue >>> 16, byteOrder);
            this.writeShort(intValue, byteOrder);
        } else {
            this.writeShort(intValue, byteOrder);
            this.writeShort(intValue >>> 16, byteOrder);
        }
    }

    public void writeLong(long value, JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            this.writeInt((int)(value >>> 32), byteOrder);
            this.writeInt((int)value, byteOrder);
        } else {
            this.writeInt((int)value, byteOrder);
            this.writeInt((int)(value >>> 32), byteOrder);
        }
    }

    public void writeDouble(double value, JBBPByteOrder byteOrder) throws IOException {
        long longValue = Double.doubleToLongBits(value);
        if (byteOrder == JBBPByteOrder.BIG_ENDIAN) {
            this.writeInt((int)(longValue >>> 32), byteOrder);
            this.writeInt((int)longValue, byteOrder);
        } else {
            this.writeInt((int)longValue, byteOrder);
            this.writeInt((int)(longValue >>> 32), byteOrder);
        }
    }

    @Override
    public long getCounter() {
        return this.byteCounter;
    }

    @Override
    public int getBitBuffer() {
        return this.bitBuffer;
    }

    @Override
    public int getBufferedBitsNumber() {
        return this.bitBufferCount;
    }

    private void flushBitBuffer() throws IOException {
        if (this.bitBufferCount > 0) {
            this.bitBufferCount = 0;
            this.writeByte(this.bitBuffer);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBitBuffer();
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bitBufferCount == 0) {
            this.out.write(b, off, len);
            this.byteCounter += (long)len;
        } else {
            int i = off;
            for (int cnt = len; cnt > 0; --cnt) {
                this.write(b[i++]);
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeBits(int value, JBBPBitNumber bitNumber) throws IOException {
        if (this.bitBufferCount == 0 && bitNumber == JBBPBitNumber.BITS_8) {
            this.write(value);
        } else {
            int initialMask = 1;
            int mask = initialMask << this.bitBufferCount;
            int accum = value;
            int i = bitNumber.getBitNumber();
            while (i > 0) {
                this.bitBuffer |= (accum & 1) == 0 ? 0 : mask;
                accum >>= 1;
                mask <<= 1;
                --i;
                ++this.bitBufferCount;
                if (this.bitBufferCount != 8) continue;
                this.bitBufferCount = 0;
                this.writeByte(this.bitBuffer);
                mask = initialMask;
                this.bitBuffer = 0;
            }
        }
    }

    public void align(long alignByteNumber) throws IOException {
        if (this.bitBufferCount > 0) {
            this.writeBits(0, JBBPBitNumber.decode(8 - this.bitBufferCount));
        }
        if (alignByteNumber > 0L) {
            for (long padding = (alignByteNumber - this.byteCounter % alignByteNumber) % alignByteNumber; padding > 0L; --padding) {
                this.out.write(0);
                ++this.byteCounter;
            }
        }
    }

    private void writeByte(int value) throws IOException {
        if (this.msb0) {
            value = JBBPUtils.reverseBitsInByte((byte)value) & 0xFF;
        }
        this.out.write(value);
        ++this.byteCounter;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void write(int value) throws IOException {
        if (this.bitBufferCount == 0) {
            this.writeByte(value);
        } else {
            this.writeBits(value, JBBPBitNumber.BITS_8);
        }
    }

    public void writeBytes(byte[] array, int length, JBBPByteOrder byteOrder) throws IOException {
        if (byteOrder == JBBPByteOrder.LITTLE_ENDIAN) {
            int i;
            int n = i = length < 0 ? array.length - 1 : length - 1;
            while (i >= 0) {
                this.write(array[i--]);
            }
        } else {
            this.write(array, 0, length < 0 ? array.length : length);
        }
    }

    @Override
    public void resetCounter() {
        this.bitBuffer = 0;
        this.bitBufferCount = 0;
        this.byteCounter = 0L;
    }

    public void writeString(String value, JBBPByteOrder order) throws IOException {
        if (value == null) {
            this.write(255);
        } else if (value.length() == 0) {
            this.write(0);
        } else {
            byte[] array = JBBPUtils.strToUtf8(value);
            int len = array.length;
            if (len < 128) {
                this.write(len);
            } else if ((len & 0xFFFFFF00) == 0) {
                this.write(129);
                this.write(len);
            } else if ((len & 0xFFFF0000) == 0) {
                this.write(130);
                this.writeShort(len, order);
            } else if ((len & 0xFF000000) == 0) {
                this.write(131);
                if (order == JBBPByteOrder.BIG_ENDIAN) {
                    this.write(len >>> 16);
                    this.write(len >>> 8);
                    this.write(len);
                } else {
                    this.write(len);
                    this.write(len >>> 8);
                    this.write(len >>> 16);
                }
            } else {
                this.write(132);
                this.writeInt(len, order);
            }
            this.write(array);
        }
    }

    public void writeStringArray(String[] value, JBBPByteOrder order) throws IOException {
        for (String s : value) {
            this.writeString(s, order);
        }
    }
}

