/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.TraceRegion;

public class TraceRegionMerger {
    private List<AbstractTraceRegion> leafRegions;

    public AbstractTraceRegion mergeTraceRegions(List<AbstractTraceRegion> roots) {
        this.leafRegions = Lists.newArrayList();
        for (AbstractTraceRegion root : roots) {
            Iterator<AbstractTraceRegion> iter = root.leafIterator();
            while (iter.hasNext()) {
                this.leafRegions.add(this.clone(iter.next()));
            }
        }
        this.mergeLeafRegions();
        AbstractTraceRegion firstLeaf = this.leafRegions.get(0);
        AbstractTraceRegion lastLeaf = this.leafRegions.get(this.leafRegions.size() - 1);
        TraceRegion mergedRoot = new TraceRegion(firstLeaf.getMyOffset(), lastLeaf.getMyOffset() + lastLeaf.getMyLength() - firstLeaf.getMyOffset(), firstLeaf.getMyLineNumber(), lastLeaf.getMyEndLineNumber(), true, Collections.emptyList(), null);
        for (AbstractTraceRegion leafRegion : this.leafRegions) {
            leafRegion.setParent(mergedRoot);
        }
        return mergedRoot;
    }

    private void mergeLeafRegions() {
        if (this.leafRegions.size() < 2) {
            return;
        }
        Collections.sort(this.leafRegions, this.getComparator());
        AbstractTraceRegion prev = this.leafRegions.get(0);
        int i = 1;
        while (i < this.leafRegions.size()) {
            AbstractTraceRegion next = this.leafRegions.get(i);
            int exclusiveEndOffset = prev.getMyOffset() + prev.getMyLength();
            int exclusiveEndLine = prev.getMyEndLineNumber();
            if (next.getMyOffset() < exclusiveEndOffset) {
                int newLength = next.getMyOffset() - prev.getMyOffset();
                prev = this.replaceTruncated(i - 1, prev, newLength, next.getMyLineNumber());
                this.doMergeLeafRegions(i, exclusiveEndOffset, exclusiveEndLine, prev.getAssociatedLocations());
                if (prev.getMyLength() == 0 && prev != this.leafRegions.remove(i - 1)) {
                    throw new IllegalStateException("removed position is not 'prev'");
                }
            }
            if (prev.getMyLength() != 0) {
                ++i;
            }
            prev = this.leafRegions.get(i - 1);
        }
    }

    private void doMergeLeafRegions(int listIdx, int exclusiveEndOffset, int inclusiveEndLine, List<ILocationData> locations) {
        int i = listIdx;
        ArrayList newRegions = null;
        AbstractTraceRegion prev = null;
        while (i < this.leafRegions.size()) {
            int prevEnd;
            AbstractTraceRegion next = this.leafRegions.get(i);
            if (next.getMyOffset() >= exclusiveEndOffset) {
                newRegions = this.addPendingRegions(prev, exclusiveEndOffset, inclusiveEndLine, locations, newRegions);
                this.partialSortRegions(listIdx, exclusiveEndOffset, i, newRegions);
                return;
            }
            if (prev != null && (prevEnd = prev.getMyOffset() + prev.getMyLength()) < next.getMyOffset()) {
                if (newRegions == null) {
                    newRegions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newRegions.add(new TraceRegion(prevEnd, next.getMyOffset() - prevEnd, prev.getMyEndLineNumber(), next.getMyLineNumber(), true, (Collection<? extends ILocationData>)locations, null));
            }
            if (next.getMyOffset() + next.getMyLength() <= exclusiveEndOffset) {
                next = this.replaceMerged(i, next, locations);
            } else {
                int oldLength = next.getMyLength();
                int oldEndLine = next.getMyEndLineNumber();
                next = this.replaceTruncated(i, next, exclusiveEndOffset - next.getMyOffset(), inclusiveEndLine);
                if (newRegions == null) {
                    newRegions = Lists.newArrayListWithExpectedSize((int)4);
                }
                newRegions.add(new TraceRegion(next.getMyOffset() + next.getMyLength(), oldLength - next.getMyLength(), inclusiveEndLine, oldEndLine, true, (Collection<? extends ILocationData>)next.getAssociatedLocations(), null));
                next = this.replaceMerged(i, next, locations);
            }
            ++i;
            prev = next;
        }
        newRegions = this.addPendingRegions(prev, exclusiveEndOffset, inclusiveEndLine, locations, newRegions);
        this.partialSortRegions(listIdx, exclusiveEndOffset, i, newRegions);
    }

    private void partialSortRegions(int listIdx, int exclusiveEndOffset, int insertionIndex, List<AbstractTraceRegion> addedRegions) {
        int addedRegionsSize;
        int n = addedRegionsSize = addedRegions != null ? addedRegions.size() : 0;
        if (addedRegionsSize != 0) {
            this.leafRegions.addAll(insertionIndex, addedRegions);
        }
        if (insertionIndex + addedRegionsSize != listIdx) {
            int endIdx = insertionIndex + addedRegionsSize;
            while (endIdx < this.leafRegions.size() && this.leafRegions.get(endIdx).getMyOffset() == exclusiveEndOffset) {
                ++endIdx;
            }
            Collections.sort(this.leafRegions.subList(listIdx, endIdx), this.getComparator());
        }
    }

    private List<AbstractTraceRegion> addPendingRegions(AbstractTraceRegion pending, int expectedEndOffset, int expectedEndLine, List<ILocationData> locations, List<AbstractTraceRegion> result) {
        int prevEnd;
        if (pending != null && (prevEnd = pending.getMyOffset() + pending.getMyLength()) < expectedEndOffset) {
            TraceRegion fillRegion = new TraceRegion(prevEnd, expectedEndOffset - prevEnd, pending.getMyEndLineNumber(), expectedEndLine, true, (Collection<? extends ILocationData>)locations, null);
            if (result == null) {
                result = Collections.singletonList(fillRegion);
            } else {
                result.add(fillRegion);
            }
        }
        return result;
    }

    private Comparator<AbstractTraceRegion> getComparator() {
        return new Comparator<AbstractTraceRegion>(){

            @Override
            public int compare(AbstractTraceRegion left, AbstractTraceRegion right) {
                int offsetDelta = left.getMyOffset() - right.getMyOffset();
                return offsetDelta != 0 ? offsetDelta : right.getMyLength() - left.getMyLength();
            }
        };
    }

    private AbstractTraceRegion replaceTruncated(int index, AbstractTraceRegion region, int newLength, int newEndLine) {
        TraceRegion truncated = new TraceRegion(region.getMyOffset(), newLength, region.getMyLineNumber(), newEndLine, true, (Collection<? extends ILocationData>)region.getAssociatedLocations(), null);
        this.leafRegions.set(index, truncated);
        return truncated;
    }

    private AbstractTraceRegion replaceMerged(int index, AbstractTraceRegion region, List<ILocationData> locationData) {
        LinkedHashSet mergedLocations = Sets.newLinkedHashSet(region.getAssociatedLocations());
        mergedLocations.addAll(locationData);
        TraceRegion merged = new TraceRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), true, mergedLocations, null);
        this.leafRegions.set(index, merged);
        return merged;
    }

    private AbstractTraceRegion clone(AbstractTraceRegion region) {
        TraceRegion merged = new TraceRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), true, (Collection<? extends ILocationData>)region.getAssociatedLocations(), null);
        return merged;
    }
}

