/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.javascript;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorToolbar;
import processing.app.Formatter;
import processing.app.Mode;
import processing.mode.java.AutoFormat;
import processing.mode.javascript.JavaScriptMode;
import processing.mode.javascript.JavaScriptToolbar;

public class JavaScriptEditor
extends Editor {
    private JavaScriptMode jsMode;

    protected JavaScriptEditor(Base base, String path, int[] location, Mode mode) {
        super(base, path, location, mode);
        this.jsMode = (JavaScriptMode)mode;
    }

    public EditorToolbar createToolbar() {
        return new JavaScriptToolbar(this, this.base);
    }

    public Formatter createFormatter() {
        return new AutoFormat();
    }

    public JMenu buildFileMenu() {
        JMenuItem exportItem = Base.newJMenuItem("export title", 69);
        exportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaScriptEditor.this.handleExport();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportItem});
    }

    public JMenu buildSketchMenu() {
        return this.buildSketchMenu(new JMenuItem[0]);
    }

    public JMenu buildHelpMenu() {
        JMenu menu = new JMenu("Help ");
        JMenuItem item = new JMenuItem("QuickStart for JS Devs");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processingjs.org/reference/articles/jsQuickStart");
            }
        });
        menu.add(item);
        item = new JMenuItem("QuickStart for Processing Devs");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processingjs.org/reference/articles/p5QuickStart");
            }
        });
        menu.add(item);
        item = new JMenuItem("Reference");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processingjs.org/reference");
            }
        });
        menu.add(item);
        item = Base.newJMenuItemShift("Find in Reference", 70);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JavaScriptEditor.this.textarea.isSelectionActive()) {
                    Base.openURL("http://www.google.com/search?q=" + JavaScriptEditor.this.textarea.getSelectedText() + "+site%3Ahttp%3A%2F%2Fprocessingjs.org%2Freference");
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("Visit Processingjs.org");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://processingjs.org/");
            }
        });
        menu.add(item);
        if (!Base.isMacOS()) {
            menu.addSeparator();
            item = new JMenuItem("About Processing");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaScriptEditor.this.base.handleAbout();
                }
            });
            menu.add(item);
        }
        return menu;
    }

    public String getCommentPrefix() {
        return "//";
    }

    public void handleExport() {
        if (this.handleExportCheckModified()) {
            this.toolbar.activate(3);
            try {
                boolean success = this.jsMode.handleExport(this.sketch);
                if (success) {
                    File appletJSFolder = new File(this.sketch.getFolder(), "applet_js");
                    Base.openFolder(appletJSFolder);
                    this.statusNotice("Finished exporting.");
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
            this.toolbar.deactivate(3);
        }
    }

    public boolean handleExportCheckModified() {
        if (this.sketch.isModified()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            int result = JOptionPane.showOptionDialog(this, "Save changes before export?", "Save", 2, 3, null, options, options[0]);
            if (result == 0) {
                this.handleSaveRequest(true);
            } else {
                this.statusNotice("Export canceled, changes must first be saved.");
                return false;
            }
        }
        return true;
    }

    public void handleSave() {
        this.toolbar.activate(2);
        super.handleSave();
        this.toolbar.deactivate(2);
    }

    public boolean handleSaveAs() {
        this.toolbar.activate(2);
        boolean result = super.handleSaveAs();
        this.toolbar.deactivate(2);
        return result;
    }

    public void handleImportLibrary(String item) {
        Base.showWarning("Processing.js doesn't support libraries", "Libraries are not supported. Import statements are ignored, and code relying on them will break.", null);
    }

    public void internalCloseRunner() {
    }

    public void deactivateRun() {
    }
}

