/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonp;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;

public class JsonValueDeserializer
extends StdDeserializer<JsonValue> {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;
    protected final boolean _forJsonValue;

    public JsonValueDeserializer(Class<?> target, JsonBuilderFactory bf) {
        super(target);
        this._builderFactory = bf;
        this._forJsonValue = target == JsonValue.class;
    }

    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    public JsonValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonObject v;
        switch (p.currentToken()) {
            case START_OBJECT: {
                v = this._deserializeObject(p, ctxt);
                break;
            }
            case START_ARRAY: {
                v = this._deserializeArray(p, ctxt);
                break;
            }
            default: {
                v = this._deserializeScalar(p, ctxt);
            }
        }
        if (!this._forJsonValue && !this.handledType().isAssignableFrom(v.getClass())) {
            ctxt.reportInputMismatch(this.handledType(), "Expected %s, but encountered %s Value", new Object[]{ClassUtil.getClassDescription((Object)this.handledType()), v.getValueType().toString()});
        }
        return v;
    }

    public JsonValue getNullValue(DeserializationContext ctxt) {
        if (this._forJsonValue) {
            return JsonValue.NULL;
        }
        return null;
    }

    public JsonValue getAbsentValue(DeserializationContext ctxt) {
        return null;
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeser) throws IOException {
        return typeDeser.deserializeTypedFromScalar(p, ctxt);
    }

    protected JsonObject _deserializeObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonObjectBuilder b = this._builderFactory.createObjectBuilder();
        block15: while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.currentName();
            JsonToken t = p.nextToken();
            switch (t) {
                case START_ARRAY: {
                    b.add(name, (JsonValue)this._deserializeArray(p, ctxt));
                    continue block15;
                }
                case START_OBJECT: {
                    b.add(name, (JsonValue)this._deserializeObject(p, ctxt));
                    continue block15;
                }
                case VALUE_FALSE: {
                    b.add(name, false);
                    continue block15;
                }
                case VALUE_TRUE: {
                    b.add(name, true);
                    continue block15;
                }
                case VALUE_NULL: {
                    b.addNull(name);
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    b.add(name, p.getDecimalValue());
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(name, p.getLongValue());
                            continue block15;
                        }
                        case INT: {
                            b.add(name, p.getIntValue());
                            continue block15;
                        }
                    }
                    b.add(name, p.getBigIntegerValue());
                    continue block15;
                }
                case VALUE_STRING: {
                    b.add(name, p.getText());
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object ob = p.getEmbeddedObject();
                    if (!(ob instanceof byte[])) break;
                    String b64 = ctxt.getBase64Variant().encode((byte[])ob, false);
                    b.add(name, b64);
                    continue block15;
                }
            }
            return (JsonObject)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
        return b.build();
    }

    protected JsonArray _deserializeArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
        block14: while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    b.add((JsonValue)this._deserializeArray(p, ctxt));
                    continue block14;
                }
                case START_OBJECT: {
                    b.add((JsonValue)this._deserializeObject(p, ctxt));
                    continue block14;
                }
                case VALUE_FALSE: {
                    b.add(false);
                    continue block14;
                }
                case VALUE_TRUE: {
                    b.add(true);
                    continue block14;
                }
                case VALUE_NULL: {
                    b.addNull();
                    continue block14;
                }
                case VALUE_NUMBER_FLOAT: {
                    b.add(p.getDecimalValue());
                    continue block14;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(p.getLongValue());
                            continue block14;
                        }
                        case INT: {
                            b.add(p.getIntValue());
                            continue block14;
                        }
                    }
                    b.add(p.getBigIntegerValue());
                    continue block14;
                }
                case VALUE_STRING: {
                    b.add(p.getText());
                    continue block14;
                }
            }
            return (JsonArray)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
        return b.build();
    }

    protected JsonValue _deserializeScalar(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                return (JsonValue)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER_FLOAT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                return (JsonValue)b.add(p.getDecimalValue()).build().get(0);
            }
            case VALUE_NUMBER_INT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                switch (p.getNumberType()) {
                    case LONG: {
                        return (JsonValue)b.add(p.getLongValue()).build().get(0);
                    }
                    case INT: {
                        return (JsonValue)b.add(p.getIntValue()).build().get(0);
                    }
                }
                return (JsonValue)b.add(p.getBigIntegerValue()).build().get(0);
            }
            case VALUE_STRING: {
                return (JsonValue)this._builderFactory.createArrayBuilder().add(p.getText()).build().get(0);
            }
        }
        return (JsonValue)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }
}

