/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.CustomSignalOperator;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class CustomSignalCondition {
    private final String customSignalKey;
    private final CustomSignalOperator customSignalOperator;
    private final ImmutableList<String> targetCustomSignalValues;

    public CustomSignalCondition(@NonNull String customSignalKey, @NonNull CustomSignalOperator customSignalOperator, @NonNull List<String> targetCustomSignalValues) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)customSignalKey) ? 1 : 0) != 0, (Object)"Custom signal key must not be null or empty.");
        Preconditions.checkNotNull((Object)((Object)customSignalOperator));
        Preconditions.checkNotNull(targetCustomSignalValues);
        Preconditions.checkArgument((!targetCustomSignalValues.isEmpty() ? 1 : 0) != 0, (Object)"Target custom signal values must not be empty.");
        this.customSignalKey = customSignalKey.trim();
        this.customSignalOperator = customSignalOperator;
        this.targetCustomSignalValues = ImmutableList.copyOf(targetCustomSignalValues);
    }

    CustomSignalCondition(ServerTemplateResponse.CustomSignalConditionResponse customSignalCondition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)customSignalCondition.getKey()) ? 1 : 0) != 0, (Object)"Custom signal key must not be null or empty.");
        Preconditions.checkArgument((!customSignalCondition.getTargetValues().isEmpty() ? 1 : 0) != 0, (Object)"Target custom signal values must not be empty.");
        this.customSignalKey = customSignalCondition.getKey().trim();
        List<String> targetCustomSignalValuesList = customSignalCondition.getTargetValues();
        this.targetCustomSignalValues = ImmutableList.copyOf(targetCustomSignalValuesList);
        switch (customSignalCondition.getOperator()) {
            case "NUMERIC_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_EQUAL;
                break;
            }
            case "NUMERIC_GREATER_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_GREATER_EQUAL;
                break;
            }
            case "NUMERIC_GREATER_THAN": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_GREATER_THAN;
                break;
            }
            case "NUMERIC_LESS_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_LESS_EQUAL;
                break;
            }
            case "NUMERIC_LESS_THAN": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_LESS_THAN;
                break;
            }
            case "NUMERIC_NOT_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.NUMERIC_NOT_EQUAL;
                break;
            }
            case "SEMANTIC_VERSION_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_EQUAL;
                break;
            }
            case "SEMANTIC_VERSION_GREATER_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_GREATER_EQUAL;
                break;
            }
            case "SEMANTIC_VERSION_GREATER_THAN": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_GREATER_THAN;
                break;
            }
            case "SEMANTIC_VERSION_LESS_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_LESS_EQUAL;
                break;
            }
            case "SEMANTIC_VERSION_LESS_THAN": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_LESS_THAN;
                break;
            }
            case "SEMANTIC_VERSION_NOT_EQUAL": {
                this.customSignalOperator = CustomSignalOperator.SEMANTIC_VERSION_NOT_EQUAL;
                break;
            }
            case "STRING_CONTAINS": {
                this.customSignalOperator = CustomSignalOperator.STRING_CONTAINS;
                break;
            }
            case "STRING_CONTAINS_REGEX": {
                this.customSignalOperator = CustomSignalOperator.STRING_CONTAINS_REGEX;
                break;
            }
            case "STRING_DOES_NOT_CONTAIN": {
                this.customSignalOperator = CustomSignalOperator.STRING_DOES_NOT_CONTAIN;
                break;
            }
            case "STRING_EXACTLY_MATCHES": {
                this.customSignalOperator = CustomSignalOperator.STRING_EXACTLY_MATCHES;
                break;
            }
            default: {
                this.customSignalOperator = CustomSignalOperator.UNSPECIFIED;
            }
        }
        Preconditions.checkArgument((this.customSignalOperator != CustomSignalOperator.UNSPECIFIED ? 1 : 0) != 0, (Object)"Custom signal operator passed is invalid");
    }

    @NonNull
    String getCustomSignalKey() {
        return this.customSignalKey;
    }

    @NonNull
    CustomSignalOperator getCustomSignalOperator() {
        return this.customSignalOperator;
    }

    @NonNull
    List<String> getTargetCustomSignalValues() {
        return new ArrayList<String>((Collection<String>)this.targetCustomSignalValues);
    }

    ServerTemplateResponse.CustomSignalConditionResponse toCustomConditonResponse() {
        ServerTemplateResponse.CustomSignalConditionResponse customSignalConditionResponse = new ServerTemplateResponse.CustomSignalConditionResponse();
        customSignalConditionResponse.setKey(this.customSignalKey);
        customSignalConditionResponse.setOperator(this.customSignalOperator.getOperator());
        customSignalConditionResponse.setTargetValues((List<String>)this.targetCustomSignalValues);
        return customSignalConditionResponse;
    }
}

