/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer;

import org.graalvm.visualvm.lib.profiler.snaptracer.ProbeItemDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.ProbeStateHandler;
import org.graalvm.visualvm.lib.profiler.snaptracer.SessionInitializationException;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProgressObject;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;

public abstract class TracerProbe {
    private final ProbeItemDescriptor[] itemDescriptors;

    public TracerProbe(ProbeItemDescriptor[] itemDescriptors) {
        if (itemDescriptors == null || itemDescriptors.length == 0) {
            throw new IllegalArgumentException("Invalid ProbeItemDescriptors");
        }
        this.itemDescriptors = itemDescriptors;
    }

    public final ProbeItemDescriptor[] getItemDescriptors() {
        return this.itemDescriptors;
    }

    public int getItemsCount() {
        return this.itemDescriptors.length;
    }

    public abstract long[] getItemValues(int var1);

    public ProbeStateHandler getStateHandler() {
        return null;
    }

    public static abstract class SessionAware
    extends TracerProbe {
        private ProbeStateHandler stateHandler;

        public SessionAware(ProbeItemDescriptor[] itemDescriptors) {
            super(itemDescriptors);
        }

        @Override
        public final synchronized ProbeStateHandler getStateHandler() {
            if (this.stateHandler == null) {
                this.stateHandler = new ProbeStateHandler(){

                    @Override
                    public void probeAdded(IdeSnapshot snapshot) {
                        this.probeAdded(snapshot);
                    }

                    @Override
                    public void probeRemoved(IdeSnapshot snapshot) {
                        this.probeRemoved(snapshot);
                    }

                    @Override
                    public TracerProgressObject sessionInitializing(IdeSnapshot snapshot, int refresh) {
                        return this.sessionInitializing(snapshot, refresh);
                    }

                    @Override
                    public void sessionStarting(IdeSnapshot snapshot) throws SessionInitializationException {
                        this.sessionStarting(snapshot);
                    }

                    @Override
                    public void sessionRunning(IdeSnapshot snapshot) {
                        this.sessionRunning(snapshot);
                    }

                    @Override
                    public void sessionStopping(IdeSnapshot snapshot) {
                        this.sessionStopping(snapshot);
                    }

                    @Override
                    public void sessionFinished(IdeSnapshot snapshot) {
                        this.sessionFinished(snapshot);
                    }

                    @Override
                    public void refreshRateChanged(IdeSnapshot snapshot, int refresh) {
                        this.refreshRateChanged(snapshot, refresh);
                    }
                };
            }
            return this.stateHandler;
        }

        protected void probeAdded(IdeSnapshot snapshot) {
        }

        protected void probeRemoved(IdeSnapshot snapshot) {
        }

        protected TracerProgressObject sessionInitializing(IdeSnapshot snapshot, int refresh) {
            return null;
        }

        protected void sessionStarting(IdeSnapshot snapshot) throws SessionInitializationException {
        }

        protected void sessionRunning(IdeSnapshot snapshot) {
        }

        protected void sessionStopping(IdeSnapshot snapshot) {
        }

        protected void sessionFinished(IdeSnapshot snapshot) {
        }

        protected void refreshRateChanged(IdeSnapshot snapshot, int refresh) {
        }
    }
}

