/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.insn.Label;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import java.util.ArrayList;
import java.util.List;

public class DebugInfoItem
extends BaseItem {
    public List<DNode> debugNodes = new ArrayList<DNode>();
    public StringIdItem[] parameterNames;
    public int firstLine;
    public StringIdItem fileName;
    static final int DBG_END_SEQUENCE = 0;
    static final int DBG_ADVANCE_PC = 1;
    static final int DBG_ADVANCE_LINE = 2;
    static final int DBG_START_LOCAL = 3;
    static final int DBG_START_LOCAL_EXTENDED = 4;
    static final int DBG_END_LOCAL = 5;
    static final int DBG_RESTART_LOCAL = 6;
    static final int DBG_SET_PROLOGUE_END = 7;
    static final int DBG_SET_EPILOGUE_BEGIN = 8;
    static final int DBG_SET_FILE = 9;
    static final int DBG_FIRST_SPECIAL = 10;
    static final int DBG_LINE_BASE = -4;
    static final int DBG_LINE_RANGE = 15;

    @Override
    public int place(int offset) {
        offset += DebugInfoItem.lengthOfUleb128(this.firstLine);
        if (this.parameterNames == null) {
            offset += DebugInfoItem.lengthOfUleb128(0);
        } else {
            offset += DebugInfoItem.lengthOfUleb128(this.parameterNames.length);
            for (StringIdItem s : this.parameterNames) {
                offset += DebugInfoItem.lengthOfUleb128(1 + (s == null ? -1 : s.index));
            }
        }
        int line = this.firstLine;
        int addr = 0;
        if (this.fileName != null) {
            ++offset;
            offset += DebugInfoItem.lengthOfUleb128(this.fileName.index + 1);
        }
        block8: for (DNode opNode : this.debugNodes) {
            switch (opNode.op) {
                case 4: {
                    offset += DebugInfoItem.lengthOfUleb128(opNode.sig.index + 1);
                }
                case 3: {
                    int pcData = opNode.label.offset - addr;
                    if (pcData < 0) {
                        throw new RuntimeException();
                    }
                    if (pcData > 0) {
                        ++offset;
                        offset += DebugInfoItem.lengthOfUleb128(pcData);
                    }
                    addr = opNode.label.offset;
                    ++offset;
                    offset += DebugInfoItem.lengthOfUleb128(opNode.reg);
                    offset += DebugInfoItem.lengthOfUleb128(opNode.name.index + 1);
                    offset += DebugInfoItem.lengthOfUleb128(opNode.type.index + 1);
                    continue block8;
                }
                case 5: 
                case 6: {
                    int pcData = opNode.label.offset - addr;
                    if (pcData < 0) {
                        throw new RuntimeException();
                    }
                    if (pcData > 0) {
                        ++offset;
                        offset += DebugInfoItem.lengthOfUleb128(pcData);
                    }
                    addr = opNode.label.offset;
                    ++offset;
                    offset += DebugInfoItem.lengthOfUleb128(opNode.reg);
                    continue block8;
                }
                case 7: 
                case 8: {
                    ++offset;
                    continue block8;
                }
                case 9: {
                    throw new RuntimeException();
                }
            }
            int lineDelta = opNode.line - line;
            int addrDelta = opNode.label.offset - addr;
            if (addrDelta < 0) {
                throw new RuntimeException();
            }
            if (opNode.label.offset == 0 && lineDelta == 0 && addrDelta == 0) continue;
            if (lineDelta < -4 || lineDelta > 10 || addrDelta > 15) {
                if (addrDelta > 15) {
                    ++offset;
                    offset += DebugInfoItem.lengthOfUleb128(addrDelta);
                    addrDelta = 0;
                }
                if (lineDelta < -4 || lineDelta > 10) {
                    ++offset;
                    offset += DebugInfoItem.lengthOfSleb128(lineDelta);
                    lineDelta = 0;
                }
            }
            ++offset;
            line = opNode.line;
            addr = opNode.label.offset;
        }
        return ++offset;
    }

    @Override
    public void write(DataOut out) {
        out.uleb128("startline", this.firstLine);
        if (this.parameterNames == null) {
            out.uleb128("szParams", 0);
        } else {
            out.uleb128("szParams", this.parameterNames.length);
            for (StringIdItem s : this.parameterNames) {
                out.uleb128p1("param_name_index", s == null ? -1 : s.index);
            }
        }
        int line = this.firstLine;
        int addr = 0;
        if (this.fileName != null) {
            out.sbyte("DBG_SET_FILE", 9);
            out.uleb128p1("filename", this.fileName.index);
        }
        block10: for (DNode opNode : this.debugNodes) {
            switch (opNode.op) {
                case 4: {
                    int pcDelta = opNode.label.offset - addr;
                    if (pcDelta < 0) {
                        throw new RuntimeException();
                    }
                    if (pcDelta > 0) {
                        this.addAdvancePC(out, pcDelta);
                    }
                    addr = opNode.label.offset;
                    out.sbyte("DBG_START_LOCAL_EXTENDED", 4);
                    out.uleb128("reg", opNode.reg);
                    out.uleb128p1("name", opNode.name.index);
                    out.uleb128p1("type", opNode.type.index);
                    out.uleb128p1("sig", opNode.sig.index);
                    continue block10;
                }
                case 3: {
                    int pcDelta = opNode.label.offset - addr;
                    if (pcDelta < 0) {
                        throw new RuntimeException();
                    }
                    if (pcDelta > 0) {
                        this.addAdvancePC(out, pcDelta);
                    }
                    addr = opNode.label.offset;
                    out.sbyte("DBG_START_LOCAL", 3);
                    out.uleb128("reg", opNode.reg);
                    out.uleb128p1("name", opNode.name.index);
                    out.uleb128p1("type", opNode.type.index);
                    continue block10;
                }
                case 6: {
                    int pcDelta = opNode.label.offset - addr;
                    if (pcDelta < 0) {
                        throw new RuntimeException();
                    }
                    if (pcDelta > 0) {
                        this.addAdvancePC(out, pcDelta);
                    }
                    addr = opNode.label.offset;
                    out.sbyte("DBG_RESTART_LOCAL", 6);
                    out.uleb128("reg", opNode.reg);
                    continue block10;
                }
                case 5: {
                    int pcDelta = opNode.label.offset - addr;
                    if (pcDelta < 0) {
                        throw new RuntimeException();
                    }
                    if (pcDelta > 0) {
                        this.addAdvancePC(out, pcDelta);
                    }
                    addr = opNode.label.offset;
                    out.sbyte("DBG_END_LOCAL", 5);
                    out.uleb128("reg", opNode.reg);
                    continue block10;
                }
                case 8: {
                    out.sbyte("DBG_SET_EPILOGUE_BEGIN", 8);
                    continue block10;
                }
                case 7: {
                    out.sbyte("DBG_SET_PROLOGUE_END", 7);
                    continue block10;
                }
                case 9: {
                    throw new RuntimeException();
                }
            }
            int lineDelta = opNode.line - line;
            int addrDelta = opNode.label.offset - addr;
            if (addrDelta < 0) {
                throw new RuntimeException();
            }
            if (opNode.label.offset == 0 && lineDelta == 0 && addrDelta == 0) continue;
            if (lineDelta < -4 || lineDelta > 10 || addrDelta > 15) {
                if (addrDelta > 15) {
                    this.addAdvancePC(out, addrDelta);
                    addrDelta = 0;
                }
                if (lineDelta < -4 || lineDelta > 10) {
                    this.addAdvanceLine(out, lineDelta);
                    lineDelta = 0;
                }
            }
            int op = lineDelta + 4 + addrDelta * 15 + 10;
            out.sbyte("DEBUG_OP_X", op);
            line = opNode.line;
            addr = opNode.label.offset;
        }
        out.sbyte("DBG_END_SEQUENCE", 0);
    }

    private void addAdvanceLine(DataOut out, int lineDelta) {
        out.sbyte("DBG_ADVANCE_LINE", 2);
        out.sleb128("offset", lineDelta);
    }

    private void addAdvancePC(DataOut out, int delta) {
        out.sbyte("DBG_ADVANCE_PC", 1);
        out.uleb128("offset", delta);
    }

    public static class DNode {
        public int op;
        public int reg;
        public int line;
        public Label label;
        StringIdItem name;
        TypeIdItem type;
        StringIdItem sig;

        public static DNode startLocal(int reg, Label label, StringIdItem name, TypeIdItem type) {
            DNode node = new DNode();
            node.reg = reg;
            node.label = label;
            node.name = name;
            node.type = type;
            node.op = 3;
            return node;
        }

        public static DNode line(int line, Label label) {
            DNode node = new DNode();
            node.line = line;
            node.label = label;
            node.op = 99999;
            return node;
        }

        public static DNode startLocalEx(int reg, Label label, StringIdItem name, TypeIdItem type, StringIdItem sig) {
            DNode node = new DNode();
            node.reg = reg;
            node.label = label;
            node.name = name;
            node.type = type;
            node.sig = sig;
            node.op = 4;
            return node;
        }

        public static DNode endLocal(int reg, Label label) {
            DNode node = new DNode();
            node.reg = reg;
            node.label = label;
            node.op = 5;
            return node;
        }

        public static DNode restartLocal(int reg, Label label) {
            DNode node = new DNode();
            node.reg = reg;
            node.label = label;
            node.op = 6;
            return node;
        }

        public static DNode epiogue(Label label) {
            DNode node = new DNode();
            node.label = label;
            node.op = 8;
            return node;
        }

        public static DNode prologue(Label label) {
            DNode node = new DNode();
            node.label = label;
            node.op = 7;
            return node;
        }
    }
}

