/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.component.resolution.failure.exception.AbstractResolutionFailureException;
import org.gradle.internal.component.resolution.failure.transform.TransformationChainData;
import org.gradle.internal.component.resolution.failure.transform.TransformedVariantConverter;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.lazy.Lazy;

final class TransformationChainsDisambiguator {
    private final ResolutionFailureHandler failureHandler;
    private final ResolvedVariantSet producer;
    private final ImmutableAttributes targetAttributes;
    private final AttributeMatcher attributeMatcher;
    private final List<TransformedVariant> preferredChains;
    private final Lazy<LinkedHashMap<TransformationChainData.TransformationChainFingerprint, TransformedVariant>> preferredChainsByFingerprint;

    public TransformationChainsDisambiguator(ResolutionFailureHandler failureHandler, ResolvedVariantSet producer, ImmutableAttributes targetAttributes, AttributeMatcher attributeMatcher, List<TransformedVariant> chainsToAssess) {
        this.failureHandler = failureHandler;
        this.producer = producer;
        this.targetAttributes = targetAttributes;
        this.attributeMatcher = attributeMatcher;
        this.preferredChains = attributeMatcher.matchMultipleCandidates(chainsToAssess, targetAttributes);
        this.preferredChainsByFingerprint = Lazy.unsafe().of(() -> {
            TransformedVariantConverter transformedVariantConverter = new TransformedVariantConverter();
            LinkedHashMap result = new LinkedHashMap(this.preferredChains.size());
            this.preferredChains.forEach(chain -> {
                TransformationChainData.TransformationChainFingerprint fingerprint = transformedVariantConverter.convert((TransformedVariant)chain).fingerprint();
                result.putIfAbsent(fingerprint, chain);
            });
            return result;
        });
    }

    public Optional<TransformedVariant> disambiguate() {
        if (this.preferredChains.size() == 1) {
            return Optional.of(this.preferredChains.get(0));
        }
        if (((LinkedHashMap)this.preferredChainsByFingerprint.get()).size() > 1) {
            if (this.allPreferredChainsAreCompatible()) {
                this.warnThatMultipleDistinctChainsAreAvailable(this.producer, this.targetAttributes, this.failureHandler, this.getDistinctPreferredChainRepresentatives());
                return this.getArbitraryPreferredMatchingChain();
            }
            throw this.failureHandler.ambiguousArtifactTransformsFailure(this.producer, this.targetAttributes, this.getDistinctPreferredChainRepresentatives());
        }
        return this.getArbitraryPreferredMatchingChain();
    }

    @Deprecated
    private void warnThatMultipleDistinctChainsAreAvailable(ResolvedVariantSet targetVariantSet, ImmutableAttributes requestedAttributes, ResolutionFailureHandler failureHandler, Collection<TransformedVariant> trulyDistinctChains) {
        try {
            throw failureHandler.ambiguousArtifactTransformsFailure(targetVariantSet, requestedAttributes, trulyDistinctChains);
        }
        catch (AbstractResolutionFailureException e) {
            int startIdx = e.getMessage().indexOf("Found multiple transformation chains");
            String context = System.lineSeparator() + e.getMessage().substring(startIdx) + System.lineSeparator();
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"There are multiple distinct artifact transformation chains of the same length that would satisfy this request.").withAdvice("Remove one or more registered transforms, or add additional attributes to them to ensure only a single valid transformation chain exists.")).withContext(context)).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecated_ambiguous_transformation_chains")).nagUser();
            return;
        }
    }

    private Optional<TransformedVariant> getArbitraryPreferredMatchingChain() {
        return !this.preferredChains.isEmpty() ? Optional.ofNullable(this.preferredChains.get(this.preferredChains.size() - 1)) : Optional.empty();
    }

    private boolean allPreferredChainsAreCompatible() {
        TransformedVariant compareTo = this.preferredChains.get(0);
        return this.preferredChains.stream().filter(current -> current != compareTo).allMatch(current -> this.attributeMatcher.areMutuallyCompatible(compareTo.getAttributes(), current.getAttributes()));
    }

    private Collection<TransformedVariant> getDistinctPreferredChainRepresentatives() {
        return ((LinkedHashMap)this.preferredChainsByFingerprint.get()).values();
    }
}

