/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.start.graph.Predicate;
import org.eclipse.jetty.start.graph.Selection;

public abstract class Node<T> {
    private String logicalName;
    private int depth = 0;
    private Set<Selection> selections = new LinkedHashSet<Selection>();
    private List<String> parentNames = new ArrayList<String>();
    private List<String> optionalParentNames = new ArrayList<String>();
    private Set<T> parentEdges = new LinkedHashSet<T>();
    private Set<T> childEdges = new LinkedHashSet<T>();

    public void addChildEdge(T child) {
        if (this.childEdges.contains(child)) {
            return;
        }
        this.childEdges.add(child);
    }

    public void addOptionalParentName(String name) {
        if (this.optionalParentNames.contains(name)) {
            return;
        }
        this.optionalParentNames.add(name);
    }

    public void addParentEdge(T parent) {
        if (this.parentEdges.contains(parent)) {
            return;
        }
        this.parentEdges.add(parent);
    }

    public void addParentName(String name) {
        if (this.parentNames.contains(name)) {
            return;
        }
        this.parentNames.add(name);
    }

    public void addSelection(Selection selection) {
        this.selections.add(selection);
    }

    public Set<T> getChildEdges() {
        return this.childEdges;
    }

    public int getDepth() {
        return this.depth;
    }

    @Deprecated
    public String getLogicalName() {
        return this.logicalName;
    }

    public String getName() {
        return this.logicalName;
    }

    public List<String> getOptionalParentNames() {
        return this.optionalParentNames;
    }

    public Set<T> getParentEdges() {
        return this.parentEdges;
    }

    public List<String> getParentNames() {
        return this.parentNames;
    }

    public Set<Selection> getSelections() {
        return this.selections;
    }

    public Set<String> getSelectedCriteriaSet() {
        HashSet<String> criteriaSet = new HashSet<String>();
        for (Selection selection : this.selections) {
            criteriaSet.add(selection.getCriteria());
        }
        return criteriaSet;
    }

    public boolean isSelected() {
        return !this.selections.isEmpty();
    }

    public boolean matches(Predicate predicate) {
        return predicate.match(this);
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setName(String name) {
        this.logicalName = name;
    }

    public void setParentNames(List<String> parents) {
        this.parentNames.clear();
        this.parentEdges.clear();
        if (parents != null) {
            this.parentNames.addAll(parents);
        }
    }

    public void setSelections(Set<Selection> selection) {
        this.selections = selection;
    }
}

