/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.TransportPacket;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.packet.namednumber.SctpPort;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SctpPacket
extends AbstractPacket
implements TransportPacket {
    private static final long serialVersionUID = -1082956644945517426L;
    private static final Logger logger = LoggerFactory.getLogger(SctpPacket.class);
    private final SctpHeader header;
    private final Packet payload;

    public static SctpPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new SctpPacket(rawData, offset, length);
    }

    private SctpPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new SctpHeader(rawData, offset, length);
        this.payload = null;
    }

    private SctpPacket(Builder builder2) {
        if (builder2 == null || builder2.srcPort == null || builder2.dstPort == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.srcPort: ").append(builder2.srcPort).append(" builder.dstPort: ").append(builder2.dstPort);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder2.payloadBuilder != null ? builder2.payloadBuilder.build() : null;
        this.header = new SctpHeader(builder2);
    }

    @Override
    public SctpHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public boolean hasValidChecksum() {
        return this.header.calcChecksum() == this.header.checksum;
    }

    public static interface SctpChunk
    extends Serializable {
        public SctpChunkType getType();

        public int length();

        public byte[] getRawData();
    }

    public static final class SctpHeader
    extends AbstractPacket.AbstractHeader
    implements TransportPacket.TransportHeader {
        private static final long serialVersionUID = -8223170335586535940L;
        private static final int SRC_PORT_OFFSET = 0;
        private static final int SRC_PORT_SIZE = 2;
        private static final int DST_PORT_OFFSET = 2;
        private static final int DST_PORT_SIZE = 2;
        private static final int VERIFICATION_TAG_OFFSET = 4;
        private static final int VERIFICAION_TAG_SIZE = 4;
        private static final int CHECKSUM_OFFSET = 8;
        private static final int CHECKSUM_SIZE = 4;
        private static final int CHUNKS_OFFSET = 12;
        private final SctpPort srcPort;
        private final SctpPort dstPort;
        private final int verificationTag;
        private final int checksum;
        private final List<SctpChunk> chunks;

        private SctpHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 12) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build a SCTP header(").append(12).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.srcPort = SctpPort.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.dstPort = SctpPort.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.verificationTag = ByteArrays.getInt(rawData, 4 + offset);
            this.checksum = ByteArrays.getInt(rawData, 8 + offset);
            this.chunks = new ArrayList<SctpChunk>();
            length -= 12;
            offset += 12;
            try {
                while (length != 0) {
                    SctpChunkType type = SctpChunkType.getInstance(rawData[offset]);
                    SctpChunk newOne = PacketFactories.getFactory(SctpChunk.class, SctpChunkType.class).newInstance(rawData, offset, length, type);
                    this.chunks.add(newOne);
                    int newOneLen = newOne.length();
                    offset += newOneLen;
                    length -= newOneLen;
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred during analyzing SCTP chunks: ", e);
                throw new IllegalRawDataException("Exception occurred during analyzing SCTP chunks", e);
            }
        }

        private SctpHeader(Builder builder2) {
            this.srcPort = builder2.srcPort;
            this.dstPort = builder2.dstPort;
            this.verificationTag = builder2.verificationTag;
            this.chunks = builder2.chunks != null ? new ArrayList<SctpChunk>(builder2.chunks) : Collections.emptyList();
            this.checksum = builder2.correctChecksumAtBuild ? this.calcChecksum() : builder2.checksum;
        }

        private int calcChecksum() {
            byte[] data = new byte[this.length()];
            System.arraycopy(this.buildRawData(), 0, data, 0, data.length);
            for (int i = 0; i < 4; ++i) {
                data[8 + i] = 0;
            }
            if (PacketPropertiesLoader.getInstance().sctpCalcChecksumByAdler32()) {
                return ByteArrays.calcAdler32Checksum(data);
            }
            int crc = ByteArrays.calcCrc32cChecksum(data);
            return crc << 24 | (crc & 0xFF00) << 8 | (crc & 0xFF0000) >> 8 | (crc & 0xFF000000) >>> 24;
        }

        @Override
        public SctpPort getSrcPort() {
            return this.srcPort;
        }

        @Override
        public SctpPort getDstPort() {
            return this.dstPort;
        }

        public int getVerificationTag() {
            return this.verificationTag;
        }

        public int getChecksum() {
            return this.checksum;
        }

        public List<SctpChunk> getChunks() {
            return new ArrayList<SctpChunk>(this.chunks);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.srcPort.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.dstPort.value()));
            rawFields.add(ByteArrays.toByteArray(this.verificationTag));
            rawFields.add(ByteArrays.toByteArray(this.checksum));
            for (SctpChunk chunk : this.chunks) {
                rawFields.add(chunk.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 12;
            for (SctpChunk chunk : this.chunks) {
                len += chunk.length();
            }
            return len;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SCTP Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Source port: ").append(this.getSrcPort()).append(ls);
            sb.append("  Destination port: ").append(this.getDstPort()).append(ls);
            sb.append("  Verification tag: 0x").append(ByteArrays.toHexString(this.verificationTag, "")).append(ls);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls);
            sb.append("  Chunks:").append(ls);
            for (SctpChunk chunk : this.chunks) {
                sb.append("    ").append(chunk).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            SctpHeader other = (SctpHeader)obj;
            return this.checksum == other.checksum && this.verificationTag == other.verificationTag && this.srcPort.equals(other.srcPort) && this.dstPort.equals(other.dstPort) && this.chunks.equals(other.chunks);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.srcPort.hashCode();
            result = 31 * result + this.dstPort.hashCode();
            result = 31 * result + this.verificationTag;
            result = 31 * result + this.checksum;
            result = 31 * result + this.chunks.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<SctpPacket> {
        private SctpPort srcPort;
        private SctpPort dstPort;
        private int verificationTag;
        private int checksum;
        private List<SctpChunk> chunks;
        private boolean correctChecksumAtBuild;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        public Builder(SctpPacket packet) {
            this.srcPort = packet.header.srcPort;
            this.dstPort = packet.header.dstPort;
            this.verificationTag = packet.header.verificationTag;
            this.checksum = packet.header.checksum;
            this.chunks = packet.header.chunks;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder srcPort(SctpPort srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public Builder dstPort(SctpPort dstPort) {
            this.dstPort = dstPort;
            return this;
        }

        public Builder verificationTag(int verificationTag) {
            this.verificationTag = verificationTag;
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder chunks(List<SctpChunk> chunks) {
            this.chunks = chunks;
            return this;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public SctpPacket build() {
            return new SctpPacket(this);
        }
    }
}

