/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.ErrorFormatter;
import org.opensearch.sql.protocol.response.format.FlatResponseBase;
import org.opensearch.sql.protocol.response.format.FlatResponseWithSanitizer;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;

public class CsvResponseFormatter
implements ResponseFormatter<QueryResult> {
    public static final String CONTENT_TYPE = "plain/text; charset=UTF-8";
    private final String separator;
    private final boolean sanitize;

    public CsvResponseFormatter() {
        this(",", true);
    }

    public CsvResponseFormatter(boolean sanitize) {
        this(",", sanitize);
    }

    public CsvResponseFormatter(String separator, boolean sanitize) {
        this.separator = separator;
        this.sanitize = sanitize;
    }

    @Override
    public String format(QueryResult response) {
        FlatResponseBase flatResponse = this.sanitize ? new FlatResponseWithSanitizer(response, this.separator) : new FlatResponseBase(response, this.separator);
        return flatResponse.format();
    }

    @Override
    public String format(Throwable t) {
        return ErrorFormatter.prettyFormat(t);
    }

    @Override
    public String contentType() {
        return CONTENT_TYPE;
    }
}

