/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.common.exception;

import java.lang.reflect.Constructor;

public class TimeSeriesException
extends RuntimeException {
    private String configId;
    private boolean countedInStats = true;

    public TimeSeriesException(String message) {
        super(message);
    }

    public TimeSeriesException(String configId, String message) {
        super(message);
        this.configId = configId;
    }

    public TimeSeriesException(String configID, String message, Throwable cause) {
        super(message, cause);
        this.configId = configID;
    }

    public TimeSeriesException(Throwable cause) {
        super(cause);
    }

    public TimeSeriesException(String configID, Throwable cause) {
        super(cause);
        this.configId = configID;
    }

    public String getConfigId() {
        return this.configId;
    }

    public boolean isCountedInStats() {
        return this.countedInStats;
    }

    public TimeSeriesException countedInStats(boolean countInStats) {
        this.countedInStats = countInStats;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.configId);
        sb.append(' ');
        sb.append(super.toString());
        return sb.toString();
    }

    public TimeSeriesException cloneWithMsgPrefix(String msgPrefix) {
        String newMessage = msgPrefix + this.getMessage();
        try {
            Class<?> cls = this.getClass();
            Constructor<?> ctor = cls.getConstructor(String.class, String.class, Throwable.class);
            TimeSeriesException newEx = (TimeSeriesException)ctor.newInstance(this.getConfigId(), newMessage, this.getCause());
            TimeSeriesException.copyExceptionDetails(this, newEx);
            return newEx;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " must provide a (String configId, String message, Throwable cause) constructor.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to clone exception: " + e.getMessage(), e);
        }
    }

    private static void copyExceptionDetails(TimeSeriesException source, TimeSeriesException target) {
        target.countedInStats(source.isCountedInStats());
        target.setStackTrace(source.getStackTrace());
        for (Throwable suppressed : source.getSuppressed()) {
            target.addSuppressed(suppressed);
        }
    }
}

