/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.protobufs.FieldWithOrderMap;
import org.opensearch.protobufs.SortCombinations;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.ScoreSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.transport.grpc.proto.request.search.sort.FieldSortBuilderProtoUtils;

public class SortBuilderProtoUtils {
    private SortBuilderProtoUtils() {
    }

    public static List<SortBuilder<?>> fromProto(List<SortCombinations> sortProto) {
        ArrayList sortFields = new ArrayList(2);
        block5: for (SortCombinations sortCombinations : sortProto) {
            switch (sortCombinations.getSortCombinationsCase()) {
                case STRING_VALUE: {
                    String name = sortCombinations.getStringValue();
                    sortFields.add(SortBuilderProtoUtils.fieldOrScoreSort(name));
                    continue block5;
                }
                case FIELD_WITH_ORDER_MAP: {
                    FieldWithOrderMap fieldWithOrderMap = sortCombinations.getFieldWithOrderMap();
                    FieldSortBuilderProtoUtils.fromProto(sortFields, fieldWithOrderMap);
                    continue block5;
                }
                case SORT_OPTIONS: {
                    throw new UnsupportedOperationException("sort options not supported yet");
                }
            }
            throw new IllegalArgumentException("Invalid sort combinations provided: " + String.valueOf(sortCombinations.getSortCombinationsCase()));
        }
        return sortFields;
    }

    public static SortBuilder<?> fieldOrScoreSort(String fieldName) {
        if (fieldName.equals("score")) {
            return new ScoreSortBuilder();
        }
        return new FieldSortBuilder(fieldName);
    }
}

