/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.CorrelatedFindingAction;
import org.opensearch.securityanalytics.action.CorrelatedFindingRequest;
import org.opensearch.securityanalytics.action.CorrelatedFindingResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchCorrelationAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchCorrelationAction.class);

    public String getName() {
        return "search_correlation_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/findings/correlate"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.ROOT, "%s %s", request.method(), "/_plugins/_security_analytics/findings/correlate"));
        String findingId = request.param("finding");
        if (findingId == null) {
            throw new IllegalArgumentException("Missing finding");
        }
        String detectorType = request.param("detector_type");
        if (detectorType == null) {
            throw new IllegalArgumentException("Missing detectorType");
        }
        long timeWindow = request.paramAsLong("time_window", 300000L);
        int noOfNearbyFindings = request.paramAsInt("nearby_findings", 10);
        CorrelatedFindingRequest correlatedFindingRequest = new CorrelatedFindingRequest(findingId, detectorType, timeWindow, noOfNearbyFindings);
        return channel -> client.execute((ActionType)CorrelatedFindingAction.INSTANCE, (ActionRequest)correlatedFindingRequest, (ActionListener)new RestCorrelatedFindingResponseListener((RestChannel)channel, request));
    }

    static class RestCorrelatedFindingResponseListener
    extends RestResponseListener<CorrelatedFindingResponse> {
        private final RestRequest request;

        RestCorrelatedFindingResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        public RestResponse buildResponse(CorrelatedFindingResponse response) throws Exception {
            return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
        }
    }
}

