/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler.monitor;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.securityanalytics.threatIntel.action.monitor.SearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.SearchThreatIntelMonitorRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchThreatIntelMonitorAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestSearchThreatIntelMonitorAction.class);
    public static final String SEARCH_THREAT_INTEL_MONITOR_PATH = "/_plugins/_security_analytics/threat_intel/monitors/_search";

    public String getName() {
        return "search_threat_intel_monitor_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, SEARCH_THREAT_INTEL_MONITOR_PATH));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), SEARCH_THREAT_INTEL_MONITOR_PATH));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(FetchSourceContext.parseFromRestRequest((RestRequest)request));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchSourceBuilder.version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{".opendistro-alerting-config"});
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        BoolQueryBuilder boolQueryBuilder = searchRequest.source().query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchRequest.source().query());
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        bqb.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchQuery((String)"monitor.owner", (Object)"security_analytics")));
        bqb.must().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchQuery((String)"monitor.monitor_type", (Object)"ti_doc_level_monitor")));
        boolQueryBuilder.filter((QueryBuilder)bqb);
        searchRequest.source().query((QueryBuilder)boolQueryBuilder);
        SearchThreatIntelMonitorRequest searchThreatIntelMonitorRequest = new SearchThreatIntelMonitorRequest(searchRequest);
        return channel -> client.execute((ActionType)SearchThreatIntelMonitorAction.INSTANCE, (ActionRequest)searchThreatIntelMonitorRequest, (ActionListener)new RestSearchThreatIntelMonitorResponseListener((RestChannel)channel, request));
    }

    static class RestSearchThreatIntelMonitorResponseListener
    extends RestResponseListener<SearchResponse> {
        private final RestRequest request;

        RestSearchThreatIntelMonitorResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        public RestResponse buildResponse(SearchResponse response) throws Exception {
            return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
        }
    }
}

