/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.judgment;

import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.transport.OpenSearchDocRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteJudgmentTransportAction
extends HandledTransportAction<OpenSearchDocRequest, DeleteResponse> {
    private final ClusterService clusterService;
    private final JudgmentDao judgmentDao;

    @Inject
    public DeleteJudgmentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, JudgmentDao judgmentDao) {
        super("cluster:admin/opensearch/search_relevance/judgment/delete", transportService, actionFilters, OpenSearchDocRequest::new);
        this.clusterService = clusterService;
        this.judgmentDao = judgmentDao;
    }

    protected void doExecute(Task task, OpenSearchDocRequest request, ActionListener<DeleteResponse> listener) {
        try {
            String judgmentId = request.getId();
            if (judgmentId == null || judgmentId.trim().isEmpty()) {
                listener.onFailure((Exception)((Object)new SearchRelevanceException("judgmentId cannot be null or empty", RestStatus.BAD_REQUEST)));
                return;
            }
            this.judgmentDao.deleteJudgment(judgmentId, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

