/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.formatter.StatsCollectorFormatter;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.rca.Version;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;

public class StatsCollector
extends PerformanceAnalyzerMetricsCollector {
    private static final Logger STATS_LOGGER = LogManager.getLogger((String)"stats_log");
    private static final Logger GENERAL_LOG = LogManager.getLogger(StatsCollector.class);
    public static final String COLLECTOR_NAME = "StatsCollector";
    public static String STATS_TYPE = "plugin-stats-metadata";
    private static final String LOG_ENTRY_INIT = "------------------------------------------------------------------------";
    private static final String LOG_ENTRY_END = "EOE";
    private static final String LOG_LINE_BREAK = "\n";
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static StatsCollector statsCollector = null;
    private final Map<String, String> metadata;
    private Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();
    private final List<StatExceptionCode> defaultExceptionCodes = new Vector<StatExceptionCode>();
    private Date objectCreationTime = new Date();

    public StatsCollector(String name, int samplingIntervalMillis, Map<String, String> metadata) {
        super(samplingIntervalMillis, name, StatMetrics.STAT_COLLECTOR_EXECUTION_TIME, StatExceptionCode.STATS_COLLECTOR_ERROR);
        this.metadata = metadata;
        this.addRcaVersionMetadata(this.metadata);
        this.defaultExceptionCodes.add(StatExceptionCode.TOTAL_ERROR);
    }

    private StatsCollector(Map<String, String> metadata) {
        this(COLLECTOR_NAME, MetricsConfiguration.CONFIG_MAP.get(StatsCollector.class).samplingInterval, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatsCollector instance() {
        if (statsCollector != null) return statsCollector;
        Class<StatsCollector> clazz = StatsCollector.class;
        synchronized (StatsCollector.class) {
            if (statsCollector != null) return statsCollector;
            statsCollector = new StatsCollector(StatsCollector.loadMetadata(PluginSettings.instance().getSettingValue(STATS_TYPE, STATS_TYPE)));
            // ** MonitorExit[var0] (shouldn't be in output)
            return statsCollector;
        }
    }

    @Override
    public void collectMetrics(long startTime) {
        Map<String, AtomicInteger> currentCounters = this.counters;
        this.counters = new ConcurrentHashMap<String, AtomicInteger>();
        for (StatExceptionCode statExceptionCode : this.defaultExceptionCodes) {
            currentCounters.putIfAbsent(statExceptionCode.toString(), new AtomicInteger(0));
        }
        StatsCollector.writeStats(this.metadata, currentCounters, null, null, this.objectCreationTime.getTime(), new Date().getTime());
        this.collectAndWriteRcaStats();
        this.objectCreationTime = new Date();
    }

    private void collectAndWriteRcaStats() {
        boolean hasNext;
        do {
            StatsCollectorFormatter formatter = new StatsCollectorFormatter();
            hasNext = ServiceMetrics.STATS_REPORTER.getNextReport(formatter);
            for (StatsCollectorFormatter.StatsCollectorReturn statsReturn : formatter.getAllMetrics()) {
                if (statsReturn.isEmpty()) continue;
                this.logStatsRecord(null, statsReturn.getStatsdata(), statsReturn.getLatencies(), statsReturn.getStartTimeMillis(), statsReturn.getEndTimeMillis());
            }
        } while (hasNext);
    }

    @VisibleForTesting
    public Map<String, AtomicInteger> getCounters() {
        return this.counters;
    }

    public void logException(StatExceptionCode statExceptionCode) {
        this.incCounter(statExceptionCode.toString());
        this.incErrorCounter();
    }

    public void logStatsRecord(Map<String, AtomicInteger> counterData, Map<String, String> statsData, Map<String, Double> latencyData, long startTimeMillis, long endTimeMillis) {
        StatsCollector.writeStats(this.metadata, counterData, statsData, latencyData, startTimeMillis, endTimeMillis);
    }

    private void addRcaVersionMetadata(Map<String, String> metadata) {
        metadata.put("rca-version", Version.getRcaVersion());
    }

    private static Map<String, String> loadMetadata(String fileLocation) {
        ConcurrentHashMap<String, String> retVal = new ConcurrentHashMap<String, String>();
        if (fileLocation != null) {
            Properties props = new Properties();
            try (FileInputStream input = new FileInputStream(PluginSettings.instance().getConfigFolderPath() + fileLocation);){
                props.load(input);
            }
            catch (Exception ex) {
                GENERAL_LOG.error("Error in loading metadata for folderLocation: {}, fileLocation: {}", (Object)PluginSettings.instance().getConfigFolderPath(), (Object)fileLocation, (Object)ex);
            }
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> retVal.put((String)key, (String)value)));
        }
        return retVal;
    }

    private void incCounter(String counterName) {
        AtomicInteger val = this.counters.putIfAbsent(counterName, new AtomicInteger(1));
        if (val != null) {
            val.getAndIncrement();
        }
    }

    private void incErrorCounter() {
        AtomicInteger all_val = this.counters.putIfAbsent(StatExceptionCode.TOTAL_ERROR.toString(), new AtomicInteger(1));
        if (all_val != null) {
            all_val.getAndIncrement();
        }
    }

    private static void writeStats(Map<String, String> metadata, Map<String, AtomicInteger> counters, Map<String, String> statsdata, Map<String, Double> latencies, long startTimeMillis, long endTimeMillis) {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------------------------------------------------------------\n");
        StatsCollector.logValues(metadata, builder);
        StatsCollector.logValues(statsdata, builder);
        StatsCollector.logTimeMetrics(startTimeMillis, endTimeMillis, builder);
        Optional.ofNullable(latencies).ifPresent(e -> latencies.put("total-time", (double)endTimeMillis - (double)startTimeMillis));
        StatsCollector.addEntry("Timing", StatsCollector.getLatencyMetrics(latencies), builder);
        StatsCollector.addEntry("Counters", StatsCollector.getCountersString(counters), builder);
        builder.append(LOG_ENTRY_END);
        STATS_LOGGER.debug(builder.toString());
    }

    private static String getCountersString(Map<String, AtomicInteger> counters) {
        StringBuilder builder = new StringBuilder();
        if (counters == null || counters.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, AtomicInteger> counter : counters.entrySet()) {
            builder.append(counter.getKey()).append("=").append(counter.getValue().get()).append(",");
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }

    private static void logTimeMetrics(long startTimeMillis, long endTimeMillis, StringBuilder builder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ROOT);
        StatsCollector.addEntry("StartTime", String.format(Locale.ROOT, "%.3f", (double)startTimeMillis / 1000.0), builder);
        StatsCollector.addEntry("EndTime", dateFormat.format(new Date(endTimeMillis)), builder);
        StatsCollector.addEntry("Time", endTimeMillis - startTimeMillis + " msecs", builder);
    }

    private static void logValues(Map<String, String> values, StringBuilder sb) {
        if (values == null) {
            return;
        }
        for (Map.Entry<String, String> entry : values.entrySet()) {
            StatsCollector.addEntry(entry.getKey(), entry.getValue(), sb);
        }
    }

    private static void addEntry(String key, Object value, StringBuilder sb) {
        sb.append(key).append('=').append(value).append(LOG_LINE_BREAK);
    }

    private static String getLatencyMetrics(Map<String, Double> values) {
        StringBuilder builder = new StringBuilder();
        if (values == null || values.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, Double> value : values.entrySet()) {
            StatsCollector.getTimingInfo(value.getKey(), value.getValue(), builder);
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }

    private static void getTimingInfo(String timerName, double latency, StringBuilder builder) {
        StatsCollector.getTimingInfo(timerName, latency, builder, 1);
    }

    private static void getTimingInfo(String timerName, double latency, StringBuilder builder, int attempts) {
        builder.append(timerName).append(":").append(latency).append("/").append(attempts).append(",");
    }
}

