/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats.suppliers;

import java.util.List;
import java.util.function.Supplier;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.ltr.breaker.LTRCircuitBreakerService;
import org.opensearch.ltr.stats.suppliers.utils.StoreUtils;
import org.opensearch.transport.client.Client;

public class PluginHealthStatusSupplier
implements Supplier<String> {
    private static final String STATUS_GREEN = "green";
    private static final String STATUS_YELLOW = "yellow";
    private static final String STATUS_RED = "red";
    private final StoreUtils storeUtils;
    private final LTRCircuitBreakerService ltrCircuitBreakerService;

    protected PluginHealthStatusSupplier(StoreUtils storeUtils, LTRCircuitBreakerService ltrCircuitBreakerService) {
        this.storeUtils = storeUtils;
        this.ltrCircuitBreakerService = ltrCircuitBreakerService;
    }

    @Override
    public String get() {
        if (this.ltrCircuitBreakerService.isOpen().booleanValue()) {
            return STATUS_RED;
        }
        return this.getAggregateStoresStatus();
    }

    private String getAggregateStoresStatus() {
        List<String> storeNames = this.storeUtils.getAllLtrStoreNames();
        return storeNames.stream().map(this.storeUtils::getLtrStoreHealthStatus).reduce(STATUS_GREEN, this::combineStatuses);
    }

    private String combineStatuses(String status1, String status2) {
        if (STATUS_RED.equals(status1) || STATUS_RED.equals(status2)) {
            return STATUS_RED;
        }
        if (STATUS_YELLOW.equals(status1) || STATUS_YELLOW.equals(status2)) {
            return STATUS_YELLOW;
        }
        return STATUS_GREEN;
    }

    public static PluginHealthStatusSupplier create(Client client, ClusterService clusterService, LTRCircuitBreakerService ltrCircuitBreakerService) {
        return new PluginHealthStatusSupplier(new StoreUtils(client, clusterService), ltrCircuitBreakerService);
    }
}

