/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import java.util.Arrays;

public class ReciprocalRankScorer
extends MetricScorer {
    public ReciprocalRankScorer() {
        this.k = 0;
    }

    @Override
    public double score(RankList rl) {
        int size = rl.size() > this.k ? this.k : rl.size();
        int firstRank = -1;
        for (int i = 0; i < size && firstRank == -1; ++i) {
            if (!((double)rl.get(i).getLabel() > 0.0)) continue;
            firstRank = i + 1;
        }
        return firstRank == -1 ? 0.0 : (double)(1.0f / (float)firstRank);
    }

    @Override
    public MetricScorer copy() {
        return new ReciprocalRankScorer();
    }

    @Override
    public String name() {
        return "RR@" + this.k;
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int firstRank = -1;
        int secondRank = -1;
        int size = rl.size() > this.k ? this.k : rl.size();
        for (int i = 0; i < size; ++i) {
            if (!((double)rl.get(i).getLabel() > 0.0)) continue;
            if (firstRank == -1) {
                firstRank = i;
                continue;
            }
            if (secondRank != -1) continue;
            secondRank = i;
        }
        double[][] changes = new double[rl.size()][];
        for (int i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        double rr = 0.0;
        if (firstRank != -1) {
            int j;
            rr = 1.0 / (double)(firstRank + 1);
            for (j = firstRank + 1; j < size; ++j) {
                if ((int)rl.get(j).getLabel() != 0) continue;
                if (secondRank == -1 || j < secondRank) {
                    double d = 1.0 / (double)(j + 1) - rr;
                    changes[j][firstRank] = d;
                    changes[firstRank][j] = d;
                    continue;
                }
                double d = 1.0 / (double)(secondRank + 1) - rr;
                changes[j][firstRank] = d;
                changes[firstRank][j] = d;
            }
            for (j = size; j < rl.size(); ++j) {
                if ((int)rl.get(j).getLabel() != 0) continue;
                if (secondRank == -1) {
                    double d = -rr;
                    changes[j][firstRank] = d;
                    changes[firstRank][j] = d;
                    continue;
                }
                double d = 1.0 / (double)(secondRank + 1) - rr;
                changes[j][firstRank] = d;
                changes[firstRank][j] = d;
            }
        } else {
            firstRank = size;
        }
        for (int i = 0; i < firstRank; ++i) {
            for (int j = firstRank; j < rl.size(); ++j) {
                if (!(rl.get(j).getLabel() > 0.0f)) continue;
                double d = 1.0 / (double)(i + 1) - rr;
                changes[j][i] = d;
                changes[i][j] = d;
            }
        }
        return changes;
    }
}

