/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreShardMetadata;
import org.opensearch.action.support.broadcast.BroadcastResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class RemoteStoreMetadataResponse
extends BroadcastResponse {
    private final RemoteStoreShardMetadata[] remoteStoreShardMetadata;

    public RemoteStoreMetadataResponse(StreamInput in) throws IOException {
        super(in);
        this.remoteStoreShardMetadata = (RemoteStoreShardMetadata[])in.readArray(RemoteStoreShardMetadata::new, RemoteStoreShardMetadata[]::new);
    }

    public RemoteStoreMetadataResponse(RemoteStoreShardMetadata[] remoteStoreShardMetadata, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.remoteStoreShardMetadata = remoteStoreShardMetadata;
    }

    public Map<String, Map<Integer, List<RemoteStoreShardMetadata>>> groupByIndexAndShards() {
        HashMap<String, Map<Integer, List<RemoteStoreShardMetadata>>> indexWiseMetadata = new HashMap<String, Map<Integer, List<RemoteStoreShardMetadata>>>();
        for (RemoteStoreShardMetadata metadata : this.remoteStoreShardMetadata) {
            indexWiseMetadata.computeIfAbsent(metadata.getIndexName(), k -> new HashMap()).computeIfAbsent(metadata.getShardId(), k -> new ArrayList()).add(metadata);
        }
        return indexWiseMetadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray((Writeable[])this.remoteStoreShardMetadata);
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map<String, Map<Integer, List<RemoteStoreShardMetadata>>> indexWiseMetadata = this.groupByIndexAndShards();
        builder.startObject("indices");
        for (String indexName : indexWiseMetadata.keySet()) {
            builder.startObject(indexName);
            builder.startObject("shards");
            for (int shardId : indexWiseMetadata.get(indexName).keySet()) {
                builder.startArray(Integer.toString(shardId));
                for (RemoteStoreShardMetadata metadata : indexWiseMetadata.get(indexName).get(shardId)) {
                    metadata.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)true, (boolean)false);
    }

    static final class Fields {
        static final String SHARDS = "shards";
        static final String INDICES = "indices";

        Fields() {
        }
    }
}

