/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.aggregations.support.ValuesSource;

class HistogramValuesSource
extends ValuesSource.Numeric {
    private final ValuesSource.Numeric vs;
    private final double interval;

    HistogramValuesSource(ValuesSource.Numeric vs, double interval) {
        this.vs = vs;
        this.interval = interval;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public boolean isBigInteger() {
        return false;
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        final SortedNumericDoubleValues values = this.vs.doubleValues(context);
        return new SortedNumericDoubleValues(this){
            final /* synthetic */ HistogramValuesSource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public double nextValue() throws IOException {
                return Math.floor(values.nextValue() / this.this$0.interval) * this.this$0.interval;
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

