/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.action.top_queries;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.plugin.insights.rules.model.MetricType;

public class TopQueriesRequest
extends BaseNodesRequest<TopQueriesRequest> {
    final MetricType metricType;
    final String from;
    final String to;
    final String id;
    final Boolean verbose;

    public TopQueriesRequest(StreamInput in) throws IOException {
        super(in);
        this.metricType = MetricType.readFromStream(in);
        if (in.getVersion().onOrAfter(Version.V_3_1_0)) {
            this.from = in.readOptionalString();
            this.to = in.readOptionalString();
            this.id = in.readOptionalString();
            this.verbose = in.readOptionalBoolean();
        } else {
            this.from = null;
            this.to = null;
            this.id = null;
            this.verbose = null;
        }
    }

    public TopQueriesRequest(MetricType metricType, String from, String to, String id, Boolean verbose, String ... nodesIds) {
        super(nodesIds);
        this.metricType = metricType;
        this.from = from;
        this.to = to;
        this.verbose = verbose;
        this.id = id;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.metricType.toString());
        if (out.getVersion().onOrAfter(Version.V_3_1_0)) {
            out.writeOptionalString(this.from);
            out.writeOptionalString(this.to);
            out.writeOptionalString(this.id);
            out.writeOptionalBoolean(this.verbose);
        }
    }
}

