/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.opensearch.rule.MatchLabel;
import org.opensearch.rule.storage.AttributeValueStore;

public class DefaultAttributeValueStore<K extends String, V>
implements AttributeValueStore<K, V> {
    private final PatriciaTrie<Set<V>> trie;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();

    public DefaultAttributeValueStore() {
        this(new PatriciaTrie());
    }

    public DefaultAttributeValueStore(PatriciaTrie<Set<V>> trie) {
        this.trie = trie;
    }

    @Override
    public void put(K key, V value) {
        writeLock.lock();
        try {
            ((Set)this.trie.computeIfAbsent(key, k -> new HashSet())).add(value);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void remove(K key, V value) {
        writeLock.lock();
        try {
            this.trie.computeIfPresent(key, (k, values) -> {
                values.remove(value);
                return values.isEmpty() ? null : values;
            });
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void remove(K key) {
        throw new UnsupportedOperationException("This remove(K key) function is not supported within DefaultAttributeValueStore.");
    }

    @Override
    public Optional<V> get(K key) {
        throw new UnsupportedOperationException("This get(K key) function is not supported within DefaultAttributeValueStore.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MatchLabel<V>> getExactMatch(K key) {
        readLock.lock();
        try {
            ArrayList<MatchLabel<V>> results = new ArrayList<MatchLabel<V>>();
            this.addMatches(results, (Set)this.trie.get(key), 1.0f);
            this.addMatches(results, (Set)this.trie.get((Object)""), 0.0f);
            ArrayList<MatchLabel<V>> arrayList = results;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MatchLabel<V>> getMatches(String key) {
        readLock.lock();
        try {
            ArrayList<MatchLabel<V>> results = new ArrayList<MatchLabel<V>>();
            StringBuilder prefixBuilder = new StringBuilder(key);
            for (int i = key.length(); i >= 0; --i) {
                Set values = (Set)this.trie.get((Object)prefixBuilder.toString());
                if (values != null && !values.isEmpty()) {
                    float score = (float)prefixBuilder.length() / (float)key.length();
                    this.addMatches(results, values, score);
                }
                if (prefixBuilder.isEmpty()) continue;
                prefixBuilder.deleteCharAt(prefixBuilder.length() - 1);
            }
            ArrayList<MatchLabel<V>> arrayList = results;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    private void addMatches(List<MatchLabel<V>> results, Set<V> values, float score) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (V label : values) {
            results.add(new MatchLabel<V>(label, score));
        }
    }

    @Override
    public void clear() {
        writeLock.lock();
        try {
            this.trie.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.trie.size();
    }
}

