/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.normalizer;

import com.o19s.es.ltr.ranker.normalizer.Normalizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Normalizers {
    private static final Map<String, Normalizer> NORMALIZERS = Collections.unmodifiableMap(new HashMap<String, Normalizer>(){
        {
            this.put(Normalizers.NOOP_NORMALIZER_NAME, new NoopNormalizer());
            this.put(Normalizers.SIGMOID_NORMALIZER_NAME, new SigmoidNormalizer());
        }
    });
    public static final String NOOP_NORMALIZER_NAME = "noop";
    public static final String SIGMOID_NORMALIZER_NAME = "sigmoid";

    public static Normalizer get(String name) {
        Normalizer normalizer = NORMALIZERS.get(name);
        if (normalizer == null) {
            throw new IllegalArgumentException(name + " is not a valid Normalizer");
        }
        return normalizer;
    }

    public static boolean exists(String name) {
        return NORMALIZERS.containsKey(name);
    }

    static class SigmoidNormalizer
    implements Normalizer {
        SigmoidNormalizer() {
        }

        @Override
        public float normalize(float val) {
            return this.sigmoid(val);
        }

        float sigmoid(float x) {
            return (float)(1.0 / (1.0 + Math.exp(-x)));
        }
    }

    static class NoopNormalizer
    implements Normalizer {
        NoopNormalizer() {
        }

        @Override
        public float normalize(float val) {
            return val;
        }
    }
}

