/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalPeek;

final class MonoPeek<T>
extends InternalMonoOperator<T, T>
implements SignalPeek<T> {
    final @Nullable Consumer<? super Subscription> onSubscribeCall;
    final @Nullable Consumer<? super T> onNextCall;
    final @Nullable LongConsumer onRequestCall;
    final @Nullable Runnable onCancelCall;

    MonoPeek(Mono<? extends T> source, @Nullable Consumer<? super Subscription> onSubscribeCall, @Nullable Consumer<? super T> onNextCall, @Nullable LongConsumer onRequestCall, @Nullable Runnable onCancelCall) {
        super(source);
        this.onSubscribeCall = onSubscribeCall;
        this.onNextCall = onNextCall;
        this.onRequestCall = onRequestCall;
        this.onCancelCall = onCancelCall;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxPeekFuseable.PeekConditionalSubscriber((Fuseable.ConditionalSubscriber)actual, this);
        }
        return new FluxPeek.PeekSubscriber<T>(actual, this);
    }

    @Override
    public @Nullable Consumer<? super Subscription> onSubscribeCall() {
        return this.onSubscribeCall;
    }

    @Override
    public @Nullable Consumer<? super T> onNextCall() {
        return this.onNextCall;
    }

    @Override
    public @Nullable Consumer<? super Throwable> onErrorCall() {
        return null;
    }

    @Override
    public @Nullable Runnable onCompleteCall() {
        return null;
    }

    @Override
    public @Nullable Runnable onAfterTerminateCall() {
        return null;
    }

    @Override
    public @Nullable LongConsumer onRequestCall() {
        return this.onRequestCall;
    }

    @Override
    public @Nullable Runnable onCancelCall() {
        return this.onCancelCall;
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

