/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l % i64vec4(165l, 133l, 193l, 76l)) => i64vec4(0l, 0l, 0l, 0l)
 * (3l % i64vec4(165l, 133l, 193l, 76l)) => i64vec4(3l, 3l, 3l, 3l)
 * (1048576l % i64vec4(165l, 133l, 193l, 76l)) => i64vec4(1l, 4l, 7l, 4l)
 * (4251475l % i64vec4(165l, 133l, 193l, 76l)) => i64vec4(85l, 130l, 71l, 35l)
 * (29852643761l % i64vec4(165l, 133l, 193l, 76l)) => i64vec4(116l, 17l, 131l, 17l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l % i64vec4(165l, 133l, 193l, 76l)), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((3l % i64vec4(165l, 133l, 193l, 76l)), i64vec4(3l, 3l, 3l, 3l))) ? 1 : -1] array1;
  float[all(equal((1048576l % i64vec4(165l, 133l, 193l, 76l)), i64vec4(1l, 4l, 7l, 4l))) ? 1 : -1] array2;
  float[all(equal((4251475l % i64vec4(165l, 133l, 193l, 76l)), i64vec4(85l, 130l, 71l, 35l))) ? 1 : -1] array3;
  float[all(equal((29852643761l % i64vec4(165l, 133l, 193l, 76l)), i64vec4(116l, 17l, 131l, 17l))) ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
