/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.lux;

import com.intellij.ui.icons.HiDPIImage;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.rd.ide.model.LxImageContent;
import com.jetbrains.rd.ide.model.LxPngImageContent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000b*\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a8\u0006\u0012"}, d2={"toLxImageContent", "Lcom/jetbrains/rd/ide/model/LxImageContent;", "Ljava/awt/Image;", "bgColor", "Ljava/awt/Color;", "x", "", "y", "width", "height", "toImage", "Ljava/awt/image/BufferedImage;", "toPngBytes", "", "fromPngBytes", "Lcom/jetbrains/rd/ide/model/LxPngImageContent;", "getImageContentSize", "imageContent", "intellij.platform.split"})
public final class LuxImageCacheKt {
    @NotNull
    public static final LxImageContent toLxImageContent(@NotNull Image $this$toLxImageContent, @Nullable Color bgColor, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$toLxImageContent, (String)"<this>");
        Image original = $this$toLxImageContent;
        double imageScale = ImageUtil.getImageScale((Image)original);
        int realWidth = (int)((double)width * imageScale);
        int realHeight = (int)((double)height * imageScale);
        JBHiDPIScaledImage jBHiDPIScaledImage = original instanceof JBHiDPIScaledImage ? (JBHiDPIScaledImage)original : null;
        Image delegate = jBHiDPIScaledImage != null ? jBHiDPIScaledImage.getDelegate() : null;
        Rectangle2D srcRect = delegate != null ? new Rectangle2D.Double((double)x * imageScale, (double)y * imageScale, (double)width * imageScale, (double)height * imageScale) : new Rectangle(x, y, width, height);
        BufferedImage bufferedImage = new BufferedImage(realWidth, realHeight, 2);
        Graphics2D g = bufferedImage.createGraphics();
        Image image = delegate;
        if (image == null) {
            image = original;
        }
        g.drawImage(image, 0, 0, realWidth, realHeight, (int)((RectangularShape)srcRect).getMinX(), (int)((RectangularShape)srcRect).getMinY(), (int)((RectangularShape)srcRect).getMaxX(), (int)((RectangularShape)srcRect).getMaxY(), bgColor, null);
        g.dispose();
        return (LxImageContent)new LxPngImageContent(LuxImageCacheKt.toPngBytes(bufferedImage), width, height);
    }

    private static final BufferedImage toImage(LxImageContent $this$toImage) {
        LxImageContent content = $this$toImage;
        if (content instanceof LxPngImageContent) {
            BufferedImage img = LuxImageCacheKt.fromPngBytes((LxPngImageContent)content);
            return (BufferedImage)new HiDPIImage((Image)img, ((LxPngImageContent)content).getUserWidth(), ((LxPngImageContent)content).getUserHeight(), 2);
        }
        throw new IllegalStateException(("unknown type of image content: " + content).toString());
    }

    private static final byte[] toPngBytes(BufferedImage $this$toPngBytes) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)$this$toPngBytes, "png", bytes);
        byte[] byArray = bytes.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    private static final BufferedImage fromPngBytes(LxPngImageContent $this$fromPngBytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream($this$fromPngBytes.getBytes());
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        return bufferedImage;
    }

    private static final int getImageContentSize(LxImageContent imageContent) {
        if (!(imageContent instanceof LxPngImageContent)) {
            throw new IllegalStateException(("unknown content: " + imageContent).toString());
        }
        return ((LxPngImageContent)imageContent).getBytes().length;
    }

    public static final /* synthetic */ BufferedImage access$toImage(LxImageContent $receiver) {
        return LuxImageCacheKt.toImage($receiver);
    }

    public static final /* synthetic */ int access$getImageContentSize(LxImageContent imageContent) {
        return LuxImageCacheKt.getImageContentSize(imageContent);
    }
}

