/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model.streaming;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;

public class StreamingUtil {
    private StreamingUtil() {
    }

    public static boolean find(JsonReader reader, String name) throws IOException {
        reader.beginObject();
        while (reader.peek() == JsonToken.NAME) {
            if (reader.nextName().equals(name)) {
                return true;
            }
            reader.skipValue();
        }
        return false;
    }

    public static void skipObjects(JsonReader reader, int num) throws IOException {
        while (num != 0 && reader.peek() == JsonToken.BEGIN_OBJECT) {
            --num;
            reader.skipValue();
        }
    }

    public static void skipToTheEndOfObject(JsonReader reader) throws IOException {
        while (reader.peek() != JsonToken.END_OBJECT) {
            reader.nextName();
            reader.skipValue();
        }
        reader.endObject();
    }
}

