/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.Border;

public final class CompositeBorder
implements Border {
    private Border[] borders;
    private Insets insets;

    public CompositeBorder(Border ... borderArray) {
        this.borders = borderArray;
        Insets insets = new Insets(0, 0, 0, 0);
        for (Border border : borderArray) {
            Insets insets2 = border.getInsets();
            insets.top += insets2.top;
            insets.left += insets2.left;
            insets.bottom += insets2.bottom;
            insets.right += insets2.right;
        }
        this.insets = insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        for (Border border : this.borders) {
            border.paint(graphics2D, new Rectangle(rectangle));
            Insets insets = border.getInsets();
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
        }
    }

    public boolean isOpaque() {
        for (Border border : this.borders) {
            if (!border.isOpaque()) continue;
            return true;
        }
        return false;
    }
}

