/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import com.nimbusds.jose.JOSEException;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.traccar.api.BaseResource;
import org.traccar.api.security.OidcSessionManager;
import org.traccar.api.signature.TokenManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.User;
import org.traccar.storage.StorageException;

@Path(value="oidc")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class OidcResource
extends BaseResource {
    @Inject
    private Config config;
    @Inject
    private TokenManager tokenManager;
    @Inject
    private OidcSessionManager sessionManager;

    @PermitAll
    @GET
    @Path(value="authorize")
    public Response authorize(@QueryParam(value="client_id") String clientId, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="state") String state, @QueryParam(value="scope") String scope, @QueryParam(value="response_type") String responseType, @QueryParam(value="code_challenge") String codeChallenge, @QueryParam(value="code_challenge_method") String codeChallengeMethod, @QueryParam(value="nonce") String nonce) {
        if (!this.getClients().containsKey(clientId)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        URI target = URI.create(redirectUri);
        String code = this.sessionManager.issueCode(this.getUserId(), clientId, target, scope, nonce, codeChallenge, codeChallengeMethod);
        UriBuilder redirectBuilder = UriBuilder.fromUri((URI)target).queryParam("code", new Object[]{code});
        if (state != null) {
            redirectBuilder.queryParam("state", new Object[]{state});
        }
        return Response.seeOther((URI)redirectBuilder.build(new Object[0])).build();
    }

    @PermitAll
    @POST
    @Path(value="token")
    public Response token(@FormParam(value="grant_type") String grantType, @FormParam(value="code") String code, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="code_verifier") String codeVerifier, @HeaderParam(value="Authorization") String authorization) throws StorageException, IOException, GeneralSecurityException, JOSEException {
        String expectedSecret;
        if (authorization != null && authorization.startsWith("Basic ")) {
            String[] credentials = new String(Base64.getDecoder().decode(authorization.substring("Basic ".length())), StandardCharsets.UTF_8).split(":");
            clientId = credentials[0];
            clientSecret = credentials[1];
        }
        if ((expectedSecret = this.getClients().get(clientId)) == null || !expectedSecret.equals(clientSecret)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        OidcSessionManager.AuthorizationCode authCode = this.sessionManager.consumeCode(code, clientId, redirectUri != null ? URI.create(redirectUri) : null, codeVerifier);
        if (authCode == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String token = this.tokenManager.generateToken(authCode.userId());
        TokenManager.TokenData tokenData = this.tokenManager.decodeToken(token);
        long expiresIn = Math.max(0L, (tokenData.getExpiration().getTime() - System.currentTimeMillis()) / 1000L);
        Set<String> scopes = this.sessionManager.parseScopes(authCode.scope());
        User user = this.permissionsService.getUser(authCode.userId());
        String idToken = this.sessionManager.generateIdToken(authCode, clientId, tokenData, scopes, user);
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("access_token", token);
        response.put("token_type", "Bearer");
        response.put("expires_in", expiresIn);
        response.put("id_token", idToken);
        response.put("scope", authCode.scope());
        return Response.ok(response).build();
    }

    @GET
    @Path(value="userinfo")
    public Map<String, Object> userInfo() throws StorageException {
        User user = this.permissionsService.getUser(this.getUserId());
        LinkedHashMap<String, Object> profile = new LinkedHashMap<String, Object>();
        profile.put("sub", String.valueOf(user.getId()));
        profile.put("name", user.getName());
        profile.put("email", user.getEmail());
        return profile;
    }

    @PermitAll
    @GET
    @Path(value="jwks")
    public Map<String, Object> jwks() throws GeneralSecurityException, StorageException, JOSEException {
        return this.sessionManager.getJwks();
    }

    private Map<String, String> getClients() {
        String value = this.config.getString(Keys.OPENID_CLIENTS);
        if (value == null || value.isBlank()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> clients = new LinkedHashMap<String, String>();
        for (String entry : value.split(",")) {
            String[] values = entry.split(":");
            clients.put(values[0], values[1]);
        }
        return clients;
    }
}

