/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.lib.collections.Logic;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.RepositoryContent;

class ResourceImpl
implements Resource,
Comparable<Resource>,
RepositoryContent {
    private volatile List<Capability> allCapabilities;
    private volatile Map<String, List<Capability>> capabilityMap;
    private volatile List<Requirement> allRequirements;
    private volatile Map<String, List<Requirement>> requirementMap;
    private volatile transient Map<URI, String> locations;

    ResourceImpl() {
    }

    void setCapabilities(List<Capability> capabilities) {
        this.allCapabilities = Collections.unmodifiableList(capabilities);
        this.capabilityMap = capabilities.stream().collect(Collectors.groupingBy(Capability::getNamespace, Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)));
        this.locations = null;
    }

    public List<Capability> getCapabilities(String namespace) {
        List<Capability> caps = namespace != null ? (this.capabilityMap != null ? this.capabilityMap.get(namespace) : null) : this.allCapabilities;
        return caps != null ? caps : Collections.emptyList();
    }

    void setRequirements(List<Requirement> requirements) {
        this.allRequirements = Collections.unmodifiableList(requirements);
        this.requirementMap = requirements.stream().collect(Collectors.groupingBy(Requirement::getNamespace, Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)));
    }

    public List<Requirement> getRequirements(String namespace) {
        List<Requirement> reqs = namespace != null ? (this.requirementMap != null ? this.requirementMap.get(namespace) : null) : this.allRequirements;
        return reqs != null ? reqs : Collections.emptyList();
    }

    public String toString() {
        List<Capability> identities = this.getCapabilities("osgi.identity");
        if (identities.size() == 1) {
            String type;
            String id;
            Map attributes = identities.get(0).getAttributes();
            switch (id = String.valueOf(attributes.get("osgi.identity"))) {
                case "<<INITIAL>>": 
                case "<<SYSTEM>>": {
                    return id;
                }
            }
            StringBuilder builder = new StringBuilder(id);
            Object version = attributes.get("version");
            if (version != null) {
                builder.append(" version=").append(version);
            }
            if (!"osgi.bundle".equals(type = attributes.getOrDefault("type", "unknown"))) {
                builder.append(" type=").append((Object)type);
            }
            return builder.toString();
        }
        return "ResourceImpl [caps=" + this.allCapabilities + ", reqs=" + this.allRequirements + ']';
    }

    @Override
    public int compareTo(Resource o) {
        return ResourceUtils.compareTo(this, o);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Map<URI, String> thisLocations = this.getLocations();
        Map<URI, String> otherLocations = other instanceof ResourceImpl ? ((ResourceImpl)other).getLocations() : ResourceUtils.getLocations((Resource)other);
        Collection<URI> overlap = Logic.retain(thisLocations.keySet(), otherLocations.keySet());
        return overlap.stream().anyMatch(uri -> {
            String thisSha = (String)thisLocations.get(uri);
            String otherSha = (String)otherLocations.get(uri);
            return Objects.equals(thisSha, otherSha);
        });
    }

    private Map<URI, String> getLocations() {
        Map<URI, String> map = this.locations;
        if (map != null) {
            return map;
        }
        this.locations = ResourceUtils.getLocations(this);
        return this.locations;
    }

    public int hashCode() {
        return this.getLocations().hashCode();
    }

    public InputStream getContent() {
        try {
            ResourceUtils.ContentCapability c = ResourceUtils.getContentCapability(this);
            URI url = c.url();
            return url.toURL().openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

